<?php

$db->query("CREATE TABLE IF NOT EXISTS idevaff_alternate_links (
  id INT(255) NOT NULL AUTO_INCREMENT ,
  aff_id INT(255) NOT NULL DEFAULT '0' ,
  url TEXT NOT NULL ,
  PRIMARY KEY (id) )
ENGINE = MyISAM");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_custom_links (
  id INT(255) NOT NULL AUTO_INCREMENT ,
  aff_id INT(255) NOT NULL ,
  url VARCHAR(255) NOT NULL ,
  display INT(1) NOT NULL ,
  PRIMARY KEY (id) )
ENGINE = MyISAM");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_delayed (
  enabled INT(1) NOT NULL DEFAULT '0' ,
  days INT(10) NOT NULL DEFAULT '0' ,
  action INT(1) NOT NULL DEFAULT '0' ,
  INDEX enabled (enabled ASC) )
ENGINE = MyISAM");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_email_templates (
  id INT(255) NOT NULL AUTO_INCREMENT ,
  name VARCHAR(128) NOT NULL DEFAULT '' ,
  grp INT(255) NOT NULL DEFAULT '0' ,
  content LONGTEXT NOT NULL ,
  hits INT(255) NOT NULL DEFAULT '0' ,
  conv INT(255) NOT NULL DEFAULT '0' ,
  PRIMARY KEY (id) )
ENGINE = MyISAM");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_groups_exclude (
  id INT(255) NOT NULL ,
  affiliate_id INT(255) NOT NULL )
ENGINE = MyISAM");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_keyword_tracking (
  id INT(255) NOT NULL AUTO_INCREMENT ,
  aff_id INT(255) NOT NULL DEFAULT '0' ,
  keyword VARCHAR(64) NOT NULL ,
  tid1 VARCHAR(64) NOT NULL ,
  tid2 VARCHAR(64) NOT NULL ,
  tid3 VARCHAR(64) NOT NULL ,
  PRIMARY KEY (id) )
ENGINE = MyISAM");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_lightboxes (
  number INT(3) NOT NULL AUTO_INCREMENT ,
  grp INT(10) NOT NULL DEFAULT '0' ,
  name VARCHAR(64) NOT NULL ,
  image75 VARCHAR(64) NOT NULL ,
  image500 VARCHAR(64) NOT NULL ,
  description TEXT NOT NULL ,
  hits INT(255) NOT NULL DEFAULT '0' ,
  conv INT(255) NOT NULL DEFAULT '0' ,
  PRIMARY KEY (number) )
ENGINE = MyISAM");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_logos (
  record INT(255) NOT NULL AUTO_INCREMENT ,
  id INT(255) NOT NULL DEFAULT '0' ,
  approved INT(1) NOT NULL DEFAULT '0' ,
  filename VARCHAR(255) NOT NULL DEFAULT '' ,
  PRIMARY KEY (record) )
ENGINE = MyISAM");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_logo_settings (
  logo_enabled int(1) NOT NULL default '0',
  logo_size int(255) NOT NULL default '0',
  logo_width int(10) NOT NULL default '0',
  logo_height int(10) NOT NULL default '0',
  logo_type int(1) NOT NULL default '0',
  logo_default varchar(255) character set utf8 NULL DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_pdf (
  id INT(255) NOT NULL AUTO_INCREMENT ,
  filename TEXT NOT NULL ,
  pdf_type INT(1) NOT NULL DEFAULT '0' ,
  size INT(255) NOT NULL DEFAULT '0' ,
  pdf_desc TEXT NOT NULL ,
  PRIMARY KEY (id) )
ENGINE = MyISAM");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_peels (
  number INT(3) NOT NULL AUTO_INCREMENT ,
  grp INT(10) NOT NULL DEFAULT '0' ,
  name VARCHAR(64) NOT NULL ,
  image75 VARCHAR(64) NOT NULL ,
  image500 VARCHAR(64) NOT NULL ,
  description TEXT NOT NULL ,
  hits INT(255) NOT NULL DEFAULT '0' ,
  conv INT(255) NOT NULL DEFAULT '0' ,
  PRIMARY KEY (number) )
ENGINE = MyISAM");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_training_videos (
  enabled INT(1) NOT NULL ,
  local_key BLOB NOT NULL ,
  directory BLOB NOT NULL ,
  address VARCHAR(64) NOT NULL ,
  payment VARCHAR(64) NOT NULL ,
  trans_id VARCHAR(64) NOT NULL )
ENGINE = MyISAM");

$db->query("CREATE TABLE IF NOT EXISTS idevaff_video_library (
  id INT(255) NOT NULL AUTO_INCREMENT ,
  video_name VARCHAR(64) NOT NULL ,
  video_dir BLOB NOT NULL ,
  video_filename BLOB NOT NULL ,
  video_query_string blob NOT NULL,
  video_size VARCHAR(64) NOT NULL ,
  video_cat INT(10) NOT NULL ,
  video_enabled INT(1) NOT NULL default '1' ,
  PRIMARY KEY (id) )
ENGINE = MyISAM");


// CHECK AFFILIATES TABLE
try {
    $db->query("ALTER TABLE idevaff_affiliates ADD `alert` int(1) NOT NULL default '0'");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("ALTER TABLE idevaff_affiliates ADD `installed` int(1) NOT NULL default '0'");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

// CHECK SALES TABLE
$checkdat = $db->query("SHOW COLUMNS from idevaff_sales LIKE 'adm_alert'");
if (!$checkdat->rowCount()) {
    try {
        $db->query("ALTER TABLE idevaff_sales ADD `adm_alert` int(1) NOT NULL default '0'");
    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }
    try {
        $db->query("ALTER TABLE idevaff_sales ADD `aff_alert` int(1) NOT NULL default '0'");
    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }

    $db->query("update idevaff_sales set aff_alert = 1");
}

// CHECK CA TABLE
$db->query("CREATE TABLE IF NOT EXISTS idevaff_alert (
  ca_use int(1) NOT NULL default '0',
  ca_show int(1) NOT NULL default '0',
  ca_adm int(1) NOT NULL default '0',
  ca_adm_tier int(1) NOT NULL default '0',
  ca_adm_rec int(1) NOT NULL default '0',
  version varchar(10) NOT NULL default ''
) ENGINE=MyISAM");

$checkdata = $db->query("select * from idevaff_alert");
if (!$checkdata->rowCount()) {
    $db->query("insert into idevaff_alert (ca_use, ca_show, ca_adm, ca_adm_tier, ca_adm_rec, version) VALUES (1, 1, 3, 1, 1, '$ca_version')");
}

try {
    $db->query('ALTER TABLE `idevaff_admin` ADD COLUMN `email` VARCHAR(255) NOT NULL  AFTER `time` ');
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query('ALTER TABLE `idevaff_affiliates` DROP COLUMN `sales` , DROP COLUMN `tagged` , DROP COLUMN `tier_sales` ');
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query('ALTER TABLE `idevaff_archive` ADD COLUMN `sub_id` VARCHAR(64) NOT NULL  AFTER `profile` , ADD COLUMN `target_url` VARCHAR(255) NOT NULL  AFTER `profile` , ADD COLUMN `tid1` VARCHAR(255) NOT NULL  AFTER `profile` , ADD COLUMN `tid2` VARCHAR(255) NOT NULL  AFTER `tid1` , ADD COLUMN `tid3` VARCHAR(255) NOT NULL  AFTER `tid2` , ADD COLUMN `tid4` VARCHAR(255) NOT NULL  AFTER `tid3`, ADD COLUMN `payment_rec` VARCHAR(255) NOT NULL default \'0\' AFTER `tid4` ');
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query('ALTER TABLE `idevaff_archive` ADD COLUMN `referring_url` VARCHAR(64) NOT NULL  AFTER `sub_id`');
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query('ALTER TABLE `idevaff_config` DROP COLUMN `storage` , ADD COLUMN `account_notify_affiliate_approved` INT(1) NOT NULL  AFTER `secret` , ADD COLUMN `admin_notify_logo` INT(1) NOT NULL  AFTER `secret` , ADD COLUMN `affiliate_notify_logo` INT(1) NOT NULL  AFTER `admin_notify_logo` , ADD COLUMN `affiliate_notify_unapproved` INT(1) NOT NULL  AFTER `affiliate_notify_logo` , ADD COLUMN `allow_alternate` INT(1) NOT NULL  AFTER `account_notify_affiliate_approved` , ADD COLUMN `bk_image` VARCHAR(255) NOT NULL  AFTER `affiliate_notify_unapproved` , ADD COLUMN `duplicate_notify` INT(1) NOT NULL  AFTER `allow_alternate` , ADD COLUMN `flashcab` VARCHAR(20) NOT NULL DEFAULT \'\'  AFTER `secret` , ADD COLUMN `fraud_type` INT(1) NOT NULL  AFTER `account_notify_affiliate_approved` , ADD COLUMN `ip_setting` VARCHAR(64) NOT NULL  AFTER `flashcab` , ADD COLUMN `lightbox_link_text` TINYTEXT NOT NULL  AFTER `bk_image` , ADD COLUMN `pass_var` INT(1) NOT NULL  AFTER `flashcab` , ADD COLUMN `second_contact` INT(1) NOT NULL DEFAULT \'0\'  AFTER `secret` , ADD COLUMN `sub_enable` INT(1) NOT NULL  AFTER `affiliate_notify_logo` , ADD COLUMN `use_security` INT(1) NOT NULL  AFTER `pass_var` , CHANGE COLUMN `paypal_cur` `paypal_cur` CHAR(3) NOT NULL  , CHANGE COLUMN `paypal_rate` `paypal_rate` DECIMAL(10,6) NOT NULL DEFAULT \'0.000000\'  , CHANGE COLUMN `offline_loc` `offline_loc` VARCHAR(128) NULL DEFAULT NULL  , CHANGE COLUMN `offline_send` `offline_send` VARCHAR(128) NULL DEFAULT NULL  , CHANGE COLUMN `offline_tag` `offline_tag` VARCHAR(64) NULL DEFAULT NULL');
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query('ALTER TABLE `idevaff_email` ADD COLUMN `admin_notify_logo_body` TEXT NOT NULL  AFTER `login_body` , ADD COLUMN `admin_notify_logo_sub` TEXT NOT NULL  AFTER `login_body` , ADD COLUMN `aff_img_app_body` TEXT NOT NULL  AFTER `admin_notify_logo_body` , ADD COLUMN `aff_img_app_sub` TEXT NOT NULL  AFTER `admin_notify_logo_body` , ADD COLUMN `aff_img_dec_body` TEXT NOT NULL  AFTER `aff_img_app_body` , ADD COLUMN `aff_img_dec_sub` TEXT NOT NULL  AFTER `aff_img_app_body` , ADD COLUMN `aff_unapprove_body` TEXT NOT NULL  AFTER `aff_img_dec_body` , ADD COLUMN `aff_unapprove_sub` TEXT NOT NULL  AFTER `aff_img_dec_body` ');
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query('ALTER TABLE `idevaff_groups` ADD COLUMN `etemps` INT(10) NOT NULL default \'0\' AFTER `location` , ADD COLUMN `lightboxes` INT(10) NOT NULL default \'0\' AFTER `etemps` , ADD COLUMN `peels` INT(10) NOT NULL default \'0\' AFTER `etemps` ');
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query('ALTER TABLE `idevaff_htmlads` CHANGE COLUMN `html_code` `html_code` TEXT NOT NULL  ');
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query('ALTER TABLE `idevaff_invoice` CHANGE COLUMN `country` `country` VARCHAR(3) NOT NULL');
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query('ALTER TABLE `idevaff_iptracking` ADD COLUMN `sub_id` VARCHAR(64) NOT NULL  AFTER `split` , ADD COLUMN `target_url` VARCHAR(64) NOT NULL  AFTER `sub_id` , ADD COLUMN `tid1` VARCHAR(64) NOT NULL  AFTER `sub_id` , ADD COLUMN `tid2` VARCHAR(64) NOT NULL  AFTER `tid1` , ADD COLUMN `tid3` VARCHAR(64) NOT NULL  AFTER `tid2` , ADD COLUMN `tid4` VARCHAR(64) NOT NULL  AFTER `tid3` ');
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query('ALTER TABLE `idevaff_language_english` DROP COLUMN `ad_button` , DROP COLUMN `ad_choose` , DROP COLUMN `ad_group` , DROP COLUMN `ad_notice` , DROP COLUMN `ad_no_group` , DROP COLUMN `ad_source` , DROP COLUMN `banners_button` , DROP COLUMN `banners_choose` , DROP COLUMN `banners_group` , DROP COLUMN `banners_notice` , DROP COLUMN `banners_no_group` , DROP COLUMN `banners_source` , DROP COLUMN `custom_browse_link` , DROP COLUMN `custom_create_button` , DROP COLUMN `custom_define_info` , DROP COLUMN `custom_define_page` , DROP COLUMN `custom_disabled_info` , DROP COLUMN `custom_disabled_title` , DROP COLUMN `custom_incoming_info` , DROP COLUMN `custom_incoming_page` , DROP COLUMN `custom_info` , DROP COLUMN `custom_keyword` , DROP COLUMN `custom_remove_success` , DROP COLUMN `custom_success` , DROP COLUMN `custom_table_delete_link` , DROP COLUMN `custom_table_hits` , DROP COLUMN `custom_table_inactive` , DROP COLUMN `custom_table_link` , DROP COLUMN `custom_table_open_link` , DROP COLUMN `custom_table_page` , DROP COLUMN `custom_table_rate` , DROP COLUMN `custom_table_remove` , DROP COLUMN `custom_table_sales` , DROP COLUMN `custom_table_title` , DROP COLUMN `custom_title` , DROP COLUMN `custom_warning_exists` , DROP COLUMN `custom_warning_invalid` , DROP COLUMN `custom_warning_none` , DROP COLUMN `custom_warning_url_invalid` , DROP COLUMN `html_button` , DROP COLUMN `html_choose` , DROP COLUMN `html_group` , DROP COLUMN `html_notice` , DROP COLUMN `html_no_group` , DROP COLUMN `html_source` , DROP COLUMN `links_button` , DROP COLUMN `links_choose` , DROP COLUMN `links_group` , DROP COLUMN `links_notice` , DROP COLUMN `links_no_group` , DROP COLUMN `links_source` , ADD COLUMN `account_hidden` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `alternate_build` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_button` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_example` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_failed_info` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_failed_title` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_heading_1` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_info_1` MEDIUMTEXT NOT NULL  AFTER `alternate_heading_1` , ADD COLUMN `alternate_info_2` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_links_heading` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_links_note` MEDIUMTEXT NOT NULL  AFTER `alternate_links_heading` , ADD COLUMN `alternate_links_remove` MEDIUMTEXT NOT NULL  AFTER `alternate_links_note` , ADD COLUMN `alternate_none` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_option_1` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_option_2` MEDIUMTEXT NOT NULL  AFTER `alternate_links_remove` , ADD COLUMN `alternate_success_info` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_success_title` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_title` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_tutorial` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_variable` MEDIUMTEXT NOT NULL  AFTER `alternate_info_2` , ADD COLUMN `cr_button` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_detailed` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_export` MEDIUMTEXT NOT NULL  AFTER `cr_detailed` , ADD COLUMN `cr_found` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_none` MEDIUMTEXT NOT NULL  AFTER `cr_export` , ADD COLUMN `cr_no_results_info` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_no_results` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_select` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_times` MEDIUMTEXT NOT NULL  AFTER `cr_found` , ADD COLUMN `cr_title` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_unique` MEDIUMTEXT NOT NULL  AFTER `cr_times` , ADD COLUMN `cr_used` MEDIUMTEXT NOT NULL  AFTER `cr_no_results_info` , ADD COLUMN `etemplates_name` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `etemplates_title` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `etemplates_view_link` MEDIUMTEXT NOT NULL  AFTER `etemplates_title` , ADD COLUMN `excel_affiliate` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_comm_current` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_comm_paid` MEDIUMTEXT NOT NULL  AFTER `excel_comm_current` , ADD COLUMN `excel_comm_ratio` MEDIUMTEXT NOT NULL  AFTER `excel_comm_paid` , ADD COLUMN `excel_comm_stats` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_comm_total` MEDIUMTEXT NOT NULL  AFTER `excel_comm_paid` , ADD COLUMN `excel_criteria` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_date` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_earned_current` MEDIUMTEXT NOT NULL  AFTER `excel_comm_ratio` , ADD COLUMN `excel_earned_paid` MEDIUMTEXT NOT NULL  AFTER `excel_earned_current` , ADD COLUMN `excel_earned_tab` MEDIUMTEXT NOT NULL  AFTER `excel_earned_paid` , ADD COLUMN `excel_earned_total` MEDIUMTEXT NOT NULL  AFTER `excel_earned_paid` , ADD COLUMN `excel_earned` MEDIUMTEXT NOT NULL  AFTER `excel_comm_ratio` , ADD COLUMN `excel_hits` MEDIUMTEXT NOT NULL  AFTER `excel_criteria` , ADD COLUMN `excel_link` MEDIUMTEXT NOT NULL  AFTER `excel_criteria` , ADD COLUMN `excel_log_date` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_log_ip` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_log_refer` MEDIUMTEXT NOT NULL  AFTER `excel_log_ip` , ADD COLUMN `excel_log_target` MEDIUMTEXT NOT NULL  AFTER `excel_log_date` , ADD COLUMN `excel_log_time` MEDIUMTEXT NOT NULL  AFTER `excel_log_date` , ADD COLUMN `excel_log_title` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_tab_logs` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_tab_report` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_title` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `keyword_build` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_example` MEDIUMTEXT NOT NULL  AFTER `keyword_build` , ADD COLUMN `keyword_heading` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_info` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_title` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_tracking` MEDIUMTEXT NOT NULL  AFTER `keyword_heading` , ADD COLUMN `keyword_tutorial` MEDIUMTEXT NOT NULL  AFTER `keyword_example` , ADD COLUMN `lb_body_click` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_body_description` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_body_source_code` MEDIUMTEXT NOT NULL  AFTER `lb_body_click` , ADD COLUMN `lb_body_title` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_code_notes` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_description` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_source_code` MEDIUMTEXT NOT NULL  AFTER `lb_head_description` , ADD COLUMN `lb_head_title`
 MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_tutorial` MEDIUMTEXT NOT NULL  AFTER `lb_head_code_notes` , ADD COLUMN `logo_approved` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bad_filetype` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_browse` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bullet_one` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bullet_pixels` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_req_size_one` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_req_size_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_req_size_one` , ADD COLUMN `logo_bullet_size_one` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_size_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_size_one` , ADD COLUMN `logo_bullet_three` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_button` MEDIUMTEXT NOT NULL  AFTER `logo_browse` , ADD COLUMN `logo_choose` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_pixels` , ADD COLUMN `logo_current` MEDIUMTEXT NOT NULL  AFTER `logo_button` , ADD COLUMN `logo_display_status` MEDIUMTEXT NOT NULL  AFTER `logo_current` , ADD COLUMN `logo_error_bytes` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `logo_error_title` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `logo_file` MEDIUMTEXT NOT NULL  AFTER `logo_choose` , ADD COLUMN `logo_info` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_maximum_height` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_maximum_width` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_missing_filename` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_pending` MEDIUMTEXT NOT NULL  AFTER `logo_display_status` , ADD COLUMN `logo_remove` MEDIUMTEXT NOT NULL  AFTER `logo_current` , ADD COLUMN `logo_required_height` MEDIUMTEXT NOT NULL  AFTER `logo_missing_filename` , ADD COLUMN `logo_required_width` MEDIUMTEXT NOT NULL  AFTER `logo_missing_filename` , ADD COLUMN `logo_size_maximum` MEDIUMTEXT NOT NULL  AFTER `logo_maximum_height` , ADD COLUMN `logo_success` MEDIUMTEXT NOT NULL  AFTER `logo_approved` , ADD COLUMN `logo_title` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_upload_error` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `marketing_group` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `marketing_source_code` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `marketing_target_url` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `menu_alteranate_links` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_custom_manual` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_custom_reports` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_drop_change` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_current` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_edit` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_general_stats` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_account` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_commissions` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_faq` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_account` , ADD COLUMN `menu_drop_heading_history` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_commissions` , ADD COLUMN `menu_drop_heading_logo` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_account` , ADD COLUMN `menu_drop_heading_stats` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_traffic` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_history` , ADD COLUMN `menu_drop_paid_rec` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_paid` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_password` MEDIUMTEXT NOT NULL  AFTER `menu_drop_edit` , ADD COLUMN `menu_drop_pending` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_recurring` MEDIUMTEXT NOT NULL  AFTER `menu_drop_paid_rec` , ADD COLUMN `menu_drop_tier_stats` MEDIUMTEXT NOT NULL  AFTER `menu_drop_general_stats` , ADD COLUMN `menu_drop_tier` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_email_templates` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_heading_additional` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_heading_custom_links` MEDIUMTEXT NOT NULL  AFTER `menu_email_templates` , ADD COLUMN `menu_heading_training_materials` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_keyword_links` MEDIUMTEXT NOT NULL  AFTER `menu_custom_reports` , ADD COLUMN `menu_lightboxes` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_page_peels` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_pdf_marketing` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `menu_pdf_training` MEDIUMTEXT NOT NULL  AFTER `menu_pdf_marketing` , ADD COLUMN `menu_subid_links` MEDIUMTEXT NOT NULL  AFTER `menu_keyword_links` , ADD COLUMN `menu_videos` MEDIUMTEXT NOT NULL  AFTER `menu_heading_training_materials` , ADD COLUMN `missing_security_code` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `pdf_bytes` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_description_1` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_description_2` MEDIUMTEXT NOT NULL  AFTER `pdf_description_1` , ADD COLUMN `pdf_file_description` MEDIUMTEXT NOT NULL  AFTER `pdf_description_2` , ADD COLUMN `pdf_file_name` MEDIUMTEXT NOT NULL  AFTER `pdf_description_2` , ADD COLUMN `pdf_file_size` MEDIUMTEXT NOT NULL  AFTER `pdf_file_name` , ADD COLUMN `pdf_marketing` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_title` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_training` MEDIUMTEXT NOT NULL  AFTER `pdf_title` , ADD COLUMN `peels_description` MEDIUMTEXT NOT NULL  AFTER `marketing_group` , ADD COLUMN `peels_title` MEDIUMTEXT NOT NULL  AFTER `marketing_group` , ADD COLUMN `peels_view` MEDIUMTEXT NOT NULL  AFTER `peels_title` , ADD COLUMN `signup_security_code` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `signup_security_info` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `signup_security_title` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `sub_tracking_build` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_example` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_build` , ADD COLUMN `sub_tracking_id` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_example` , ADD COLUMN `sub_tracking_info` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_none` MEDIUMTEXT NOT NULL  AFTER `signup_security_code` , ADD COLUMN `sub_tracking_title` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_tutorial` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_example` , CHANGE COLUMN `banners_size` `banners_size` MEDIUMTEXT NOT NULL  AFTER `marketing_group` ');
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

// UPDATE GOLD/PLATINUM/SEO WITH LANGUAGE ITEMS
$checkifplatplus = $db->query("select id from idevaff_language_packs");
if ($checkifplatplus->rowCount() > 1) {
    try {
        $db->query('ALTER TABLE `idevaff_language_spanish` DROP COLUMN `ad_button` , DROP COLUMN `ad_choose` , DROP COLUMN `ad_group` , DROP COLUMN `ad_notice` , DROP COLUMN `ad_no_group` , DROP COLUMN `ad_source` , DROP COLUMN `banners_button` , DROP COLUMN `banners_choose` , DROP COLUMN `banners_group` , DROP COLUMN `banners_notice` , DROP COLUMN `banners_no_group` , DROP COLUMN `banners_source` , DROP COLUMN `custom_browse_link` , DROP COLUMN `custom_create_button` , DROP COLUMN `custom_define_info` , DROP COLUMN `custom_define_page` , DROP COLUMN `custom_disabled_info` , DROP COLUMN `custom_disabled_title` , DROP COLUMN `custom_incoming_info` , DROP COLUMN `custom_incoming_page` , DROP COLUMN `custom_info` , DROP COLUMN `custom_keyword` , DROP COLUMN `custom_remove_success` , DROP COLUMN `custom_success` , DROP COLUMN `custom_table_delete_link` , DROP COLUMN `custom_table_hits` , DROP COLUMN `custom_table_inactive` , DROP COLUMN `custom_table_link` , DROP COLUMN `custom_table_open_link` , DROP COLUMN `custom_table_page` , DROP COLUMN `custom_table_rate` , DROP COLUMN `custom_table_remove` , DROP COLUMN `custom_table_sales` , DROP COLUMN `custom_table_title` , DROP COLUMN `custom_title` , DROP COLUMN `custom_warning_exists` , DROP COLUMN `custom_warning_invalid` , DROP COLUMN `custom_warning_none` , DROP COLUMN `custom_warning_url_invalid` , DROP COLUMN `html_button` , DROP COLUMN `html_choose` , DROP COLUMN `html_group` , DROP COLUMN `html_notice` , DROP COLUMN `html_no_group` , DROP COLUMN `html_source` , DROP COLUMN `links_button` , DROP COLUMN `links_choose` , DROP COLUMN `links_group` , DROP COLUMN `links_notice` , DROP COLUMN `links_no_group` , DROP COLUMN `links_source` , ADD COLUMN `account_hidden` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `alternate_build` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_button` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_example` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_failed_info` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_failed_title` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_heading_1` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_info_1` MEDIUMTEXT NOT NULL  AFTER `alternate_heading_1` , ADD COLUMN `alternate_info_2` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_links_heading` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_links_note` MEDIUMTEXT NOT NULL  AFTER `alternate_links_heading` , ADD COLUMN `alternate_links_remove` MEDIUMTEXT NOT NULL  AFTER `alternate_links_note` , ADD COLUMN `alternate_none` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_option_1` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_option_2` MEDIUMTEXT NOT NULL  AFTER `alternate_links_remove` , ADD COLUMN `alternate_success_info` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_success_title` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_title` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_tutorial` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_variable` MEDIUMTEXT NOT NULL  AFTER `alternate_info_2` , ADD COLUMN `cr_button` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_detailed` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_export` MEDIUMTEXT NOT NULL  AFTER `cr_detailed` , ADD COLUMN `cr_found` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_none` MEDIUMTEXT NOT NULL  AFTER `cr_export` , ADD COLUMN `cr_no_results_info` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_no_results` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_select` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_times` MEDIUMTEXT NOT NULL  AFTER `cr_found` , ADD COLUMN `cr_title` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_unique` MEDIUMTEXT NOT NULL  AFTER `cr_times` , ADD COLUMN `cr_used` MEDIUMTEXT NOT NULL  AFTER `cr_no_results_info` , ADD COLUMN `etemplates_name` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `etemplates_title` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `etemplates_view_link` MEDIUMTEXT NOT NULL  AFTER `etemplates_title` , ADD COLUMN `excel_affiliate` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_comm_current` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_comm_paid` MEDIUMTEXT NOT NULL  AFTER `excel_comm_current` , ADD COLUMN `excel_comm_ratio` MEDIUMTEXT NOT NULL  AFTER `excel_comm_paid` , ADD COLUMN `excel_comm_stats` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_comm_total` MEDIUMTEXT NOT NULL  AFTER `excel_comm_paid` , ADD COLUMN `excel_criteria` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_date` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_earned_current` MEDIUMTEXT NOT NULL  AFTER `excel_comm_ratio` , ADD COLUMN `excel_earned_paid` MEDIUMTEXT NOT NULL  AFTER `excel_earned_current` , ADD COLUMN `excel_earned_tab` MEDIUMTEXT NOT NULL  AFTER `excel_earned_paid` , ADD COLUMN `excel_earned_total` MEDIUMTEXT NOT NULL  AFTER `excel_earned_paid` , ADD COLUMN `excel_earned` MEDIUMTEXT NOT NULL  AFTER `excel_comm_ratio` , ADD COLUMN `excel_hits` MEDIUMTEXT NOT NULL  AFTER `excel_criteria` , ADD COLUMN `excel_link` MEDIUMTEXT NOT NULL  AFTER `excel_criteria` , ADD COLUMN `excel_log_date` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_log_ip` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_log_refer` MEDIUMTEXT NOT NULL  AFTER `excel_log_ip` , ADD COLUMN `excel_log_target` MEDIUMTEXT NOT NULL  AFTER `excel_log_date` , ADD COLUMN `excel_log_time` MEDIUMTEXT NOT NULL  AFTER `excel_log_date` , ADD COLUMN `excel_log_title` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_tab_logs` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_tab_report` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_title` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `keyword_build` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_example` MEDIUMTEXT NOT NULL  AFTER `keyword_build` , ADD COLUMN `keyword_heading` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_info` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_title` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_tracking` MEDIUMTEXT NOT NULL  AFTER `keyword_heading` , ADD COLUMN `keyword_tutorial` MEDIUMTEXT NOT NULL  AFTER `keyword_example` , ADD COLUMN `lb_body_click` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_body_description` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_body_source_code` MEDIUMTEXT NOT NULL  AFTER `lb_body_click` , ADD COLUMN `lb_body_title` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_code_notes` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_description` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_source_code` MEDIUMTEXT NOT NULL  AFTER `lb_head_description` , ADD COLUMN `lb_head_title`
 MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_tutorial` MEDIUMTEXT NOT NULL  AFTER `lb_head_code_notes` , ADD COLUMN `logo_approved` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bad_filetype` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_browse` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bullet_one` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bullet_pixels` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_req_size_one` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_req_size_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_req_size_one` , ADD COLUMN `logo_bullet_size_one` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_size_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_size_one` , ADD COLUMN `logo_bullet_three` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_button` MEDIUMTEXT NOT NULL  AFTER `logo_browse` , ADD COLUMN `logo_choose` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_pixels` , ADD COLUMN `logo_current` MEDIUMTEXT NOT NULL  AFTER `logo_button` , ADD COLUMN `logo_display_status` MEDIUMTEXT NOT NULL  AFTER `logo_current` , ADD COLUMN `logo_error_bytes` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `logo_error_title` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `logo_file` MEDIUMTEXT NOT NULL  AFTER `logo_choose` , ADD COLUMN `logo_info` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_maximum_height` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_maximum_width` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_missing_filename` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_pending` MEDIUMTEXT NOT NULL  AFTER `logo_display_status` , ADD COLUMN `logo_remove` MEDIUMTEXT NOT NULL  AFTER `logo_current` , ADD COLUMN `logo_required_height` MEDIUMTEXT NOT NULL  AFTER `logo_missing_filename` , ADD COLUMN `logo_required_width` MEDIUMTEXT NOT NULL  AFTER `logo_missing_filename` , ADD COLUMN `logo_size_maximum` MEDIUMTEXT NOT NULL  AFTER `logo_maximum_height` , ADD COLUMN `logo_success` MEDIUMTEXT NOT NULL  AFTER `logo_approved` , ADD COLUMN `logo_title` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_upload_error` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `marketing_group` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `marketing_source_code` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `marketing_target_url` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `menu_alteranate_links` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_custom_manual` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_custom_reports` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_drop_change` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_current` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_edit` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_general_stats` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_account` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_commissions` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_faq` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_account` , ADD COLUMN `menu_drop_heading_history` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_commissions` , ADD COLUMN `menu_drop_heading_logo` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_account` , ADD COLUMN `menu_drop_heading_stats` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_traffic` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_history` , ADD COLUMN `menu_drop_paid_rec` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_paid` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_password` MEDIUMTEXT NOT NULL  AFTER `menu_drop_edit` , ADD COLUMN `menu_drop_pending` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_recurring` MEDIUMTEXT NOT NULL  AFTER `menu_drop_paid_rec` , ADD COLUMN `menu_drop_tier_stats` MEDIUMTEXT NOT NULL  AFTER `menu_drop_general_stats` , ADD COLUMN `menu_drop_tier` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_email_templates` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_heading_additional` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_heading_custom_links` MEDIUMTEXT NOT NULL  AFTER `menu_email_templates` , ADD COLUMN `menu_heading_training_materials` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_keyword_links` MEDIUMTEXT NOT NULL  AFTER `menu_custom_reports` , ADD COLUMN `menu_lightboxes` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_page_peels` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_pdf_marketing` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `menu_pdf_training` MEDIUMTEXT NOT NULL  AFTER `menu_pdf_marketing` , ADD COLUMN `menu_subid_links` MEDIUMTEXT NOT NULL  AFTER `menu_keyword_links` , ADD COLUMN `menu_videos` MEDIUMTEXT NOT NULL  AFTER `menu_heading_training_materials` , ADD COLUMN `missing_security_code` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `pdf_bytes` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_description_1` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_description_2` MEDIUMTEXT NOT NULL  AFTER `pdf_description_1` , ADD COLUMN `pdf_file_description` MEDIUMTEXT NOT NULL  AFTER `pdf_description_2` , ADD COLUMN `pdf_file_name` MEDIUMTEXT NOT NULL  AFTER `pdf_description_2` , ADD COLUMN `pdf_file_size` MEDIUMTEXT NOT NULL  AFTER `pdf_file_name` , ADD COLUMN `pdf_marketing` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_title` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_training` MEDIUMTEXT NOT NULL  AFTER `pdf_title` , ADD COLUMN `peels_description` MEDIUMTEXT NOT NULL  AFTER `marketing_group` , ADD COLUMN `peels_title` MEDIUMTEXT NOT NULL  AFTER `marketing_group` , ADD COLUMN `peels_view` MEDIUMTEXT NOT NULL  AFTER `peels_title` , ADD COLUMN `signup_security_code` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `signup_security_info` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `signup_security_title` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `sub_tracking_build` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_example` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_build` , ADD COLUMN `sub_tracking_id` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_example` , ADD COLUMN `sub_tracking_info` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_none` MEDIUMTEXT NOT NULL  AFTER `signup_security_code` , ADD COLUMN `sub_tracking_title` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_tutorial` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_example` , CHANGE COLUMN `banners_size` `banners_size` MEDIUMTEXT NOT NULL  AFTER `marketing_group` ');
    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }
    try {
        $db->query('ALTER TABLE `idevaff_language_german` DROP COLUMN `ad_button` , DROP COLUMN `ad_choose` , DROP COLUMN `ad_group` , DROP COLUMN `ad_notice` , DROP COLUMN `ad_no_group` , DROP COLUMN `ad_source` , DROP COLUMN `banners_button` , DROP COLUMN `banners_choose` , DROP COLUMN `banners_group` , DROP COLUMN `banners_notice` , DROP COLUMN `banners_no_group` , DROP COLUMN `banners_source` , DROP COLUMN `custom_browse_link` , DROP COLUMN `custom_create_button` , DROP COLUMN `custom_define_info` , DROP COLUMN `custom_define_page` , DROP COLUMN `custom_disabled_info` , DROP COLUMN `custom_disabled_title` , DROP COLUMN `custom_incoming_info` , DROP COLUMN `custom_incoming_page` , DROP COLUMN `custom_info` , DROP COLUMN `custom_keyword` , DROP COLUMN `custom_remove_success` , DROP COLUMN `custom_success` , DROP COLUMN `custom_table_delete_link` , DROP COLUMN `custom_table_hits` , DROP COLUMN `custom_table_inactive` , DROP COLUMN `custom_table_link` , DROP COLUMN `custom_table_open_link` , DROP COLUMN `custom_table_page` , DROP COLUMN `custom_table_rate` , DROP COLUMN `custom_table_remove` , DROP COLUMN `custom_table_sales` , DROP COLUMN `custom_table_title` , DROP COLUMN `custom_title` , DROP COLUMN `custom_warning_exists` , DROP COLUMN `custom_warning_invalid` , DROP COLUMN `custom_warning_none` , DROP COLUMN `custom_warning_url_invalid` , DROP COLUMN `html_button` , DROP COLUMN `html_choose` , DROP COLUMN `html_group` , DROP COLUMN `html_notice` , DROP COLUMN `html_no_group` , DROP COLUMN `html_source` , DROP COLUMN `links_button` , DROP COLUMN `links_choose` , DROP COLUMN `links_group` , DROP COLUMN `links_notice` , DROP COLUMN `links_no_group` , DROP COLUMN `links_source` , ADD COLUMN `account_hidden` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `alternate_build` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_button` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_example` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_failed_info` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_failed_title` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_heading_1` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_info_1` MEDIUMTEXT NOT NULL  AFTER `alternate_heading_1` , ADD COLUMN `alternate_info_2` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_links_heading` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_links_note` MEDIUMTEXT NOT NULL  AFTER `alternate_links_heading` , ADD COLUMN `alternate_links_remove` MEDIUMTEXT NOT NULL  AFTER `alternate_links_note` , ADD COLUMN `alternate_none` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_option_1` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_option_2` MEDIUMTEXT NOT NULL  AFTER `alternate_links_remove` , ADD COLUMN `alternate_success_info` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_success_title` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_title` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_tutorial` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_variable` MEDIUMTEXT NOT NULL  AFTER `alternate_info_2` , ADD COLUMN `cr_button` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_detailed` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_export` MEDIUMTEXT NOT NULL  AFTER `cr_detailed` , ADD COLUMN `cr_found` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_none` MEDIUMTEXT NOT NULL  AFTER `cr_export` , ADD COLUMN `cr_no_results_info` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_no_results` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_select` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_times` MEDIUMTEXT NOT NULL  AFTER `cr_found` , ADD COLUMN `cr_title` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_unique` MEDIUMTEXT NOT NULL  AFTER `cr_times` , ADD COLUMN `cr_used` MEDIUMTEXT NOT NULL  AFTER `cr_no_results_info` , ADD COLUMN `etemplates_name` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `etemplates_title` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `etemplates_view_link` MEDIUMTEXT NOT NULL  AFTER `etemplates_title` , ADD COLUMN `excel_affiliate` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_comm_current` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_comm_paid` MEDIUMTEXT NOT NULL  AFTER `excel_comm_current` , ADD COLUMN `excel_comm_ratio` MEDIUMTEXT NOT NULL  AFTER `excel_comm_paid` , ADD COLUMN `excel_comm_stats` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_comm_total` MEDIUMTEXT NOT NULL  AFTER `excel_comm_paid` , ADD COLUMN `excel_criteria` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_date` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_earned_current` MEDIUMTEXT NOT NULL  AFTER `excel_comm_ratio` , ADD COLUMN `excel_earned_paid` MEDIUMTEXT NOT NULL  AFTER `excel_earned_current` , ADD COLUMN `excel_earned_tab` MEDIUMTEXT NOT NULL  AFTER `excel_earned_paid` , ADD COLUMN `excel_earned_total` MEDIUMTEXT NOT NULL  AFTER `excel_earned_paid` , ADD COLUMN `excel_earned` MEDIUMTEXT NOT NULL  AFTER `excel_comm_ratio` , ADD COLUMN `excel_hits` MEDIUMTEXT NOT NULL  AFTER `excel_criteria` , ADD COLUMN `excel_link` MEDIUMTEXT NOT NULL  AFTER `excel_criteria` , ADD COLUMN `excel_log_date` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_log_ip` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_log_refer` MEDIUMTEXT NOT NULL  AFTER `excel_log_ip` , ADD COLUMN `excel_log_target` MEDIUMTEXT NOT NULL  AFTER `excel_log_date` , ADD COLUMN `excel_log_time` MEDIUMTEXT NOT NULL  AFTER `excel_log_date` , ADD COLUMN `excel_log_title` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_tab_logs` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_tab_report` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_title` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `keyword_build` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_example` MEDIUMTEXT NOT NULL  AFTER `keyword_build` , ADD COLUMN `keyword_heading` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_info` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_title` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_tracking` MEDIUMTEXT NOT NULL  AFTER `keyword_heading` , ADD COLUMN `keyword_tutorial` MEDIUMTEXT NOT NULL  AFTER `keyword_example` , ADD COLUMN `lb_body_click` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_body_description` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_body_source_code` MEDIUMTEXT NOT NULL  AFTER `lb_body_click` , ADD COLUMN `lb_body_title` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_code_notes` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_description` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_source_code` MEDIUMTEXT NOT NULL  AFTER `lb_head_description` , ADD COLUMN `lb_head_title`
 MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_tutorial` MEDIUMTEXT NOT NULL  AFTER `lb_head_code_notes` , ADD COLUMN `logo_approved` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bad_filetype` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_browse` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bullet_one` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bullet_pixels` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_req_size_one` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_req_size_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_req_size_one` , ADD COLUMN `logo_bullet_size_one` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_size_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_size_one` , ADD COLUMN `logo_bullet_three` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_button` MEDIUMTEXT NOT NULL  AFTER `logo_browse` , ADD COLUMN `logo_choose` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_pixels` , ADD COLUMN `logo_current` MEDIUMTEXT NOT NULL  AFTER `logo_button` , ADD COLUMN `logo_display_status` MEDIUMTEXT NOT NULL  AFTER `logo_current` , ADD COLUMN `logo_error_bytes` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `logo_error_title` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `logo_file` MEDIUMTEXT NOT NULL  AFTER `logo_choose` , ADD COLUMN `logo_info` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_maximum_height` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_maximum_width` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_missing_filename` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_pending` MEDIUMTEXT NOT NULL  AFTER `logo_display_status` , ADD COLUMN `logo_remove` MEDIUMTEXT NOT NULL  AFTER `logo_current` , ADD COLUMN `logo_required_height` MEDIUMTEXT NOT NULL  AFTER `logo_missing_filename` , ADD COLUMN `logo_required_width` MEDIUMTEXT NOT NULL  AFTER `logo_missing_filename` , ADD COLUMN `logo_size_maximum` MEDIUMTEXT NOT NULL  AFTER `logo_maximum_height` , ADD COLUMN `logo_success` MEDIUMTEXT NOT NULL  AFTER `logo_approved` , ADD COLUMN `logo_title` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_upload_error` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `marketing_group` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `marketing_source_code` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `marketing_target_url` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `menu_alteranate_links` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_custom_manual` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_custom_reports` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_drop_change` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_current` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_edit` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_general_stats` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_account` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_commissions` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_faq` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_account` , ADD COLUMN `menu_drop_heading_history` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_commissions` , ADD COLUMN `menu_drop_heading_logo` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_account` , ADD COLUMN `menu_drop_heading_stats` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_traffic` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_history` , ADD COLUMN `menu_drop_paid_rec` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_paid` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_password` MEDIUMTEXT NOT NULL  AFTER `menu_drop_edit` , ADD COLUMN `menu_drop_pending` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_recurring` MEDIUMTEXT NOT NULL  AFTER `menu_drop_paid_rec` , ADD COLUMN `menu_drop_tier_stats` MEDIUMTEXT NOT NULL  AFTER `menu_drop_general_stats` , ADD COLUMN `menu_drop_tier` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_email_templates` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_heading_additional` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_heading_custom_links` MEDIUMTEXT NOT NULL  AFTER `menu_email_templates` , ADD COLUMN `menu_heading_training_materials` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_keyword_links` MEDIUMTEXT NOT NULL  AFTER `menu_custom_reports` , ADD COLUMN `menu_lightboxes` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_page_peels` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_pdf_marketing` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `menu_pdf_training` MEDIUMTEXT NOT NULL  AFTER `menu_pdf_marketing` , ADD COLUMN `menu_subid_links` MEDIUMTEXT NOT NULL  AFTER `menu_keyword_links` , ADD COLUMN `menu_videos` MEDIUMTEXT NOT NULL  AFTER `menu_heading_training_materials` , ADD COLUMN `missing_security_code` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `pdf_bytes` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_description_1` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_description_2` MEDIUMTEXT NOT NULL  AFTER `pdf_description_1` , ADD COLUMN `pdf_file_description` MEDIUMTEXT NOT NULL  AFTER `pdf_description_2` , ADD COLUMN `pdf_file_name` MEDIUMTEXT NOT NULL  AFTER `pdf_description_2` , ADD COLUMN `pdf_file_size` MEDIUMTEXT NOT NULL  AFTER `pdf_file_name` , ADD COLUMN `pdf_marketing` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_title` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_training` MEDIUMTEXT NOT NULL  AFTER `pdf_title` , ADD COLUMN `peels_description` MEDIUMTEXT NOT NULL  AFTER `marketing_group` , ADD COLUMN `peels_title` MEDIUMTEXT NOT NULL  AFTER `marketing_group` , ADD COLUMN `peels_view` MEDIUMTEXT NOT NULL  AFTER `peels_title` , ADD COLUMN `signup_security_code` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `signup_security_info` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `signup_security_title` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `sub_tracking_build` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_example` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_build` , ADD COLUMN `sub_tracking_id` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_example` , ADD COLUMN `sub_tracking_info` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_none` MEDIUMTEXT NOT NULL  AFTER `signup_security_code` , ADD COLUMN `sub_tracking_title` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_tutorial` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_example` , CHANGE COLUMN `banners_size` `banners_size` MEDIUMTEXT NOT NULL  AFTER `marketing_group` ');
    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }
    try {
        $db->query('ALTER TABLE `idevaff_language_portuguese` DROP COLUMN `ad_button` , DROP COLUMN `ad_choose` , DROP COLUMN `ad_group` , DROP COLUMN `ad_notice` , DROP COLUMN `ad_no_group` , DROP COLUMN `ad_source` , DROP COLUMN `banners_button` , DROP COLUMN `banners_choose` , DROP COLUMN `banners_group` , DROP COLUMN `banners_notice` , DROP COLUMN `banners_no_group` , DROP COLUMN `banners_source` , DROP COLUMN `custom_browse_link` , DROP COLUMN `custom_create_button` , DROP COLUMN `custom_define_info` , DROP COLUMN `custom_define_page` , DROP COLUMN `custom_disabled_info` , DROP COLUMN `custom_disabled_title` , DROP COLUMN `custom_incoming_info` , DROP COLUMN `custom_incoming_page` , DROP COLUMN `custom_info` , DROP COLUMN `custom_keyword` , DROP COLUMN `custom_remove_success` , DROP COLUMN `custom_success` , DROP COLUMN `custom_table_delete_link` , DROP COLUMN `custom_table_hits` , DROP COLUMN `custom_table_inactive` , DROP COLUMN `custom_table_link` , DROP COLUMN `custom_table_open_link` , DROP COLUMN `custom_table_page` , DROP COLUMN `custom_table_rate` , DROP COLUMN `custom_table_remove` , DROP COLUMN `custom_table_sales` , DROP COLUMN `custom_table_title` , DROP COLUMN `custom_title` , DROP COLUMN `custom_warning_exists` , DROP COLUMN `custom_warning_invalid` , DROP COLUMN `custom_warning_none` , DROP COLUMN `custom_warning_url_invalid` , DROP COLUMN `html_button` , DROP COLUMN `html_choose` , DROP COLUMN `html_group` , DROP COLUMN `html_notice` , DROP COLUMN `html_no_group` , DROP COLUMN `html_source` , DROP COLUMN `links_button` , DROP COLUMN `links_choose` , DROP COLUMN `links_group` , DROP COLUMN `links_notice` , DROP COLUMN `links_no_group` , DROP COLUMN `links_source` , ADD COLUMN `account_hidden` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `alternate_build` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_button` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_example` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_failed_info` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_failed_title` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_heading_1` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_info_1` MEDIUMTEXT NOT NULL  AFTER `alternate_heading_1` , ADD COLUMN `alternate_info_2` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_links_heading` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_links_note` MEDIUMTEXT NOT NULL  AFTER `alternate_links_heading` , ADD COLUMN `alternate_links_remove` MEDIUMTEXT NOT NULL  AFTER `alternate_links_note` , ADD COLUMN `alternate_none` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_option_1` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_option_2` MEDIUMTEXT NOT NULL  AFTER `alternate_links_remove` , ADD COLUMN `alternate_success_info` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_success_title` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_title` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_tutorial` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_variable` MEDIUMTEXT NOT NULL  AFTER `alternate_info_2` , ADD COLUMN `cr_button` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_detailed` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_export` MEDIUMTEXT NOT NULL  AFTER `cr_detailed` , ADD COLUMN `cr_found` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_none` MEDIUMTEXT NOT NULL  AFTER `cr_export` , ADD COLUMN `cr_no_results_info` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_no_results` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_select` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_times` MEDIUMTEXT NOT NULL  AFTER `cr_found` , ADD COLUMN `cr_title` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_unique` MEDIUMTEXT NOT NULL  AFTER `cr_times` , ADD COLUMN `cr_used` MEDIUMTEXT NOT NULL  AFTER `cr_no_results_info` , ADD COLUMN `etemplates_name` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `etemplates_title` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `etemplates_view_link` MEDIUMTEXT NOT NULL  AFTER `etemplates_title` , ADD COLUMN `excel_affiliate` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_comm_current` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_comm_paid` MEDIUMTEXT NOT NULL  AFTER `excel_comm_current` , ADD COLUMN `excel_comm_ratio` MEDIUMTEXT NOT NULL  AFTER `excel_comm_paid` , ADD COLUMN `excel_comm_stats` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_comm_total` MEDIUMTEXT NOT NULL  AFTER `excel_comm_paid` , ADD COLUMN `excel_criteria` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_date` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_earned_current` MEDIUMTEXT NOT NULL  AFTER `excel_comm_ratio` , ADD COLUMN `excel_earned_paid` MEDIUMTEXT NOT NULL  AFTER `excel_earned_current` , ADD COLUMN `excel_earned_tab` MEDIUMTEXT NOT NULL  AFTER `excel_earned_paid` , ADD COLUMN `excel_earned_total` MEDIUMTEXT NOT NULL  AFTER `excel_earned_paid` , ADD COLUMN `excel_earned` MEDIUMTEXT NOT NULL  AFTER `excel_comm_ratio` , ADD COLUMN `excel_hits` MEDIUMTEXT NOT NULL  AFTER `excel_criteria` , ADD COLUMN `excel_link` MEDIUMTEXT NOT NULL  AFTER `excel_criteria` , ADD COLUMN `excel_log_date` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_log_ip` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_log_refer` MEDIUMTEXT NOT NULL  AFTER `excel_log_ip` , ADD COLUMN `excel_log_target` MEDIUMTEXT NOT NULL  AFTER `excel_log_date` , ADD COLUMN `excel_log_time` MEDIUMTEXT NOT NULL  AFTER `excel_log_date` , ADD COLUMN `excel_log_title` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_tab_logs` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_tab_report` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_title` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `keyword_build` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_example` MEDIUMTEXT NOT NULL  AFTER `keyword_build` , ADD COLUMN `keyword_heading` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_info` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_title` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_tracking` MEDIUMTEXT NOT NULL  AFTER `keyword_heading` , ADD COLUMN `keyword_tutorial` MEDIUMTEXT NOT NULL  AFTER `keyword_example` , ADD COLUMN `lb_body_click` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_body_description` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_body_source_code` MEDIUMTEXT NOT NULL  AFTER `lb_body_click` , ADD COLUMN `lb_body_title` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_code_notes` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_description` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_source_code` MEDIUMTEXT NOT NULL  AFTER `lb_head_description` , ADD COLUMN `lb_head_title`
 MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_tutorial` MEDIUMTEXT NOT NULL  AFTER `lb_head_code_notes` , ADD COLUMN `logo_approved` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bad_filetype` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_browse` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bullet_one` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bullet_pixels` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_req_size_one` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_req_size_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_req_size_one` , ADD COLUMN `logo_bullet_size_one` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_size_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_size_one` , ADD COLUMN `logo_bullet_three` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_button` MEDIUMTEXT NOT NULL  AFTER `logo_browse` , ADD COLUMN `logo_choose` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_pixels` , ADD COLUMN `logo_current` MEDIUMTEXT NOT NULL  AFTER `logo_button` , ADD COLUMN `logo_display_status` MEDIUMTEXT NOT NULL  AFTER `logo_current` , ADD COLUMN `logo_error_bytes` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `logo_error_title` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `logo_file` MEDIUMTEXT NOT NULL  AFTER `logo_choose` , ADD COLUMN `logo_info` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_maximum_height` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_maximum_width` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_missing_filename` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_pending` MEDIUMTEXT NOT NULL  AFTER `logo_display_status` , ADD COLUMN `logo_remove` MEDIUMTEXT NOT NULL  AFTER `logo_current` , ADD COLUMN `logo_required_height` MEDIUMTEXT NOT NULL  AFTER `logo_missing_filename` , ADD COLUMN `logo_required_width` MEDIUMTEXT NOT NULL  AFTER `logo_missing_filename` , ADD COLUMN `logo_size_maximum` MEDIUMTEXT NOT NULL  AFTER `logo_maximum_height` , ADD COLUMN `logo_success` MEDIUMTEXT NOT NULL  AFTER `logo_approved` , ADD COLUMN `logo_title` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_upload_error` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `marketing_group` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `marketing_source_code` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `marketing_target_url` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `menu_alteranate_links` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_custom_manual` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_custom_reports` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_drop_change` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_current` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_edit` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_general_stats` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_account` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_commissions` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_faq` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_account` , ADD COLUMN `menu_drop_heading_history` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_commissions` , ADD COLUMN `menu_drop_heading_logo` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_account` , ADD COLUMN `menu_drop_heading_stats` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_traffic` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_history` , ADD COLUMN `menu_drop_paid_rec` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_paid` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_password` MEDIUMTEXT NOT NULL  AFTER `menu_drop_edit` , ADD COLUMN `menu_drop_pending` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_recurring` MEDIUMTEXT NOT NULL  AFTER `menu_drop_paid_rec` , ADD COLUMN `menu_drop_tier_stats` MEDIUMTEXT NOT NULL  AFTER `menu_drop_general_stats` , ADD COLUMN `menu_drop_tier` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_email_templates` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_heading_additional` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_heading_custom_links` MEDIUMTEXT NOT NULL  AFTER `menu_email_templates` , ADD COLUMN `menu_heading_training_materials` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_keyword_links` MEDIUMTEXT NOT NULL  AFTER `menu_custom_reports` , ADD COLUMN `menu_lightboxes` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_page_peels` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_pdf_marketing` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `menu_pdf_training` MEDIUMTEXT NOT NULL  AFTER `menu_pdf_marketing` , ADD COLUMN `menu_subid_links` MEDIUMTEXT NOT NULL  AFTER `menu_keyword_links` , ADD COLUMN `menu_videos` MEDIUMTEXT NOT NULL  AFTER `menu_heading_training_materials` , ADD COLUMN `missing_security_code` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `pdf_bytes` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_description_1` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_description_2` MEDIUMTEXT NOT NULL  AFTER `pdf_description_1` , ADD COLUMN `pdf_file_description` MEDIUMTEXT NOT NULL  AFTER `pdf_description_2` , ADD COLUMN `pdf_file_name` MEDIUMTEXT NOT NULL  AFTER `pdf_description_2` , ADD COLUMN `pdf_file_size` MEDIUMTEXT NOT NULL  AFTER `pdf_file_name` , ADD COLUMN `pdf_marketing` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_title` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_training` MEDIUMTEXT NOT NULL  AFTER `pdf_title` , ADD COLUMN `peels_description` MEDIUMTEXT NOT NULL  AFTER `marketing_group` , ADD COLUMN `peels_title` MEDIUMTEXT NOT NULL  AFTER `marketing_group` , ADD COLUMN `peels_view` MEDIUMTEXT NOT NULL  AFTER `peels_title` , ADD COLUMN `signup_security_code` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `signup_security_info` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `signup_security_title` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `sub_tracking_build` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_example` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_build` , ADD COLUMN `sub_tracking_id` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_example` , ADD COLUMN `sub_tracking_info` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_none` MEDIUMTEXT NOT NULL  AFTER `signup_security_code` , ADD COLUMN `sub_tracking_title` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_tutorial` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_example` , CHANGE COLUMN `banners_size` `banners_size` MEDIUMTEXT NOT NULL  AFTER `marketing_group` ');
    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }
    try {
        $db->query('ALTER TABLE `idevaff_language_dutch` DROP COLUMN `ad_button` , DROP COLUMN `ad_choose` , DROP COLUMN `ad_group` , DROP COLUMN `ad_notice` , DROP COLUMN `ad_no_group` , DROP COLUMN `ad_source` , DROP COLUMN `banners_button` , DROP COLUMN `banners_choose` , DROP COLUMN `banners_group` , DROP COLUMN `banners_notice` , DROP COLUMN `banners_no_group` , DROP COLUMN `banners_source` , DROP COLUMN `custom_browse_link` , DROP COLUMN `custom_create_button` , DROP COLUMN `custom_define_info` , DROP COLUMN `custom_define_page` , DROP COLUMN `custom_disabled_info` , DROP COLUMN `custom_disabled_title` , DROP COLUMN `custom_incoming_info` , DROP COLUMN `custom_incoming_page` , DROP COLUMN `custom_info` , DROP COLUMN `custom_keyword` , DROP COLUMN `custom_remove_success` , DROP COLUMN `custom_success` , DROP COLUMN `custom_table_delete_link` , DROP COLUMN `custom_table_hits` , DROP COLUMN `custom_table_inactive` , DROP COLUMN `custom_table_link` , DROP COLUMN `custom_table_open_link` , DROP COLUMN `custom_table_page` , DROP COLUMN `custom_table_rate` , DROP COLUMN `custom_table_remove` , DROP COLUMN `custom_table_sales` , DROP COLUMN `custom_table_title` , DROP COLUMN `custom_title` , DROP COLUMN `custom_warning_exists` , DROP COLUMN `custom_warning_invalid` , DROP COLUMN `custom_warning_none` , DROP COLUMN `custom_warning_url_invalid` , DROP COLUMN `html_button` , DROP COLUMN `html_choose` , DROP COLUMN `html_group` , DROP COLUMN `html_notice` , DROP COLUMN `html_no_group` , DROP COLUMN `html_source` , DROP COLUMN `links_button` , DROP COLUMN `links_choose` , DROP COLUMN `links_group` , DROP COLUMN `links_notice` , DROP COLUMN `links_no_group` , DROP COLUMN `links_source` , ADD COLUMN `account_hidden` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `alternate_build` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_button` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_example` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_failed_info` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_failed_title` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_heading_1` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_info_1` MEDIUMTEXT NOT NULL  AFTER `alternate_heading_1` , ADD COLUMN `alternate_info_2` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_links_heading` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_links_note` MEDIUMTEXT NOT NULL  AFTER `alternate_links_heading` , ADD COLUMN `alternate_links_remove` MEDIUMTEXT NOT NULL  AFTER `alternate_links_note` , ADD COLUMN `alternate_none` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_option_1` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_option_2` MEDIUMTEXT NOT NULL  AFTER `alternate_links_remove` , ADD COLUMN `alternate_success_info` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_success_title` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_title` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_tutorial` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_variable` MEDIUMTEXT NOT NULL  AFTER `alternate_info_2` , ADD COLUMN `cr_button` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_detailed` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_export` MEDIUMTEXT NOT NULL  AFTER `cr_detailed` , ADD COLUMN `cr_found` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_none` MEDIUMTEXT NOT NULL  AFTER `cr_export` , ADD COLUMN `cr_no_results_info` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_no_results` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_select` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_times` MEDIUMTEXT NOT NULL  AFTER `cr_found` , ADD COLUMN `cr_title` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_unique` MEDIUMTEXT NOT NULL  AFTER `cr_times` , ADD COLUMN `cr_used` MEDIUMTEXT NOT NULL  AFTER `cr_no_results_info` , ADD COLUMN `etemplates_name` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `etemplates_title` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `etemplates_view_link` MEDIUMTEXT NOT NULL  AFTER `etemplates_title` , ADD COLUMN `excel_affiliate` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_comm_current` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_comm_paid` MEDIUMTEXT NOT NULL  AFTER `excel_comm_current` , ADD COLUMN `excel_comm_ratio` MEDIUMTEXT NOT NULL  AFTER `excel_comm_paid` , ADD COLUMN `excel_comm_stats` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_comm_total` MEDIUMTEXT NOT NULL  AFTER `excel_comm_paid` , ADD COLUMN `excel_criteria` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_date` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_earned_current` MEDIUMTEXT NOT NULL  AFTER `excel_comm_ratio` , ADD COLUMN `excel_earned_paid` MEDIUMTEXT NOT NULL  AFTER `excel_earned_current` , ADD COLUMN `excel_earned_tab` MEDIUMTEXT NOT NULL  AFTER `excel_earned_paid` , ADD COLUMN `excel_earned_total` MEDIUMTEXT NOT NULL  AFTER `excel_earned_paid` , ADD COLUMN `excel_earned` MEDIUMTEXT NOT NULL  AFTER `excel_comm_ratio` , ADD COLUMN `excel_hits` MEDIUMTEXT NOT NULL  AFTER `excel_criteria` , ADD COLUMN `excel_link` MEDIUMTEXT NOT NULL  AFTER `excel_criteria` , ADD COLUMN `excel_log_date` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_log_ip` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_log_refer` MEDIUMTEXT NOT NULL  AFTER `excel_log_ip` , ADD COLUMN `excel_log_target` MEDIUMTEXT NOT NULL  AFTER `excel_log_date` , ADD COLUMN `excel_log_time` MEDIUMTEXT NOT NULL  AFTER `excel_log_date` , ADD COLUMN `excel_log_title` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_tab_logs` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_tab_report` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_title` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `keyword_build` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_example` MEDIUMTEXT NOT NULL  AFTER `keyword_build` , ADD COLUMN `keyword_heading` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_info` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_title` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_tracking` MEDIUMTEXT NOT NULL  AFTER `keyword_heading` , ADD COLUMN `keyword_tutorial` MEDIUMTEXT NOT NULL  AFTER `keyword_example` , ADD COLUMN `lb_body_click` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_body_description` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_body_source_code` MEDIUMTEXT NOT NULL  AFTER `lb_body_click` , ADD COLUMN `lb_body_title` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_code_notes` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_description` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_source_code` MEDIUMTEXT NOT NULL  AFTER `lb_head_description` , ADD COLUMN `lb_head_title`
 MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_tutorial` MEDIUMTEXT NOT NULL  AFTER `lb_head_code_notes` , ADD COLUMN `logo_approved` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bad_filetype` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_browse` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bullet_one` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bullet_pixels` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_req_size_one` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_req_size_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_req_size_one` , ADD COLUMN `logo_bullet_size_one` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_size_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_size_one` , ADD COLUMN `logo_bullet_three` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_button` MEDIUMTEXT NOT NULL  AFTER `logo_browse` , ADD COLUMN `logo_choose` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_pixels` , ADD COLUMN `logo_current` MEDIUMTEXT NOT NULL  AFTER `logo_button` , ADD COLUMN `logo_display_status` MEDIUMTEXT NOT NULL  AFTER `logo_current` , ADD COLUMN `logo_error_bytes` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `logo_error_title` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `logo_file` MEDIUMTEXT NOT NULL  AFTER `logo_choose` , ADD COLUMN `logo_info` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_maximum_height` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_maximum_width` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_missing_filename` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_pending` MEDIUMTEXT NOT NULL  AFTER `logo_display_status` , ADD COLUMN `logo_remove` MEDIUMTEXT NOT NULL  AFTER `logo_current` , ADD COLUMN `logo_required_height` MEDIUMTEXT NOT NULL  AFTER `logo_missing_filename` , ADD COLUMN `logo_required_width` MEDIUMTEXT NOT NULL  AFTER `logo_missing_filename` , ADD COLUMN `logo_size_maximum` MEDIUMTEXT NOT NULL  AFTER `logo_maximum_height` , ADD COLUMN `logo_success` MEDIUMTEXT NOT NULL  AFTER `logo_approved` , ADD COLUMN `logo_title` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_upload_error` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `marketing_group` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `marketing_source_code` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `marketing_target_url` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `menu_alteranate_links` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_custom_manual` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_custom_reports` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_drop_change` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_current` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_edit` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_general_stats` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_account` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_commissions` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_faq` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_account` , ADD COLUMN `menu_drop_heading_history` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_commissions` , ADD COLUMN `menu_drop_heading_logo` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_account` , ADD COLUMN `menu_drop_heading_stats` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_traffic` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_history` , ADD COLUMN `menu_drop_paid_rec` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_paid` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_password` MEDIUMTEXT NOT NULL  AFTER `menu_drop_edit` , ADD COLUMN `menu_drop_pending` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_recurring` MEDIUMTEXT NOT NULL  AFTER `menu_drop_paid_rec` , ADD COLUMN `menu_drop_tier_stats` MEDIUMTEXT NOT NULL  AFTER `menu_drop_general_stats` , ADD COLUMN `menu_drop_tier` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_email_templates` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_heading_additional` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_heading_custom_links` MEDIUMTEXT NOT NULL  AFTER `menu_email_templates` , ADD COLUMN `menu_heading_training_materials` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_keyword_links` MEDIUMTEXT NOT NULL  AFTER `menu_custom_reports` , ADD COLUMN `menu_lightboxes` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_page_peels` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_pdf_marketing` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `menu_pdf_training` MEDIUMTEXT NOT NULL  AFTER `menu_pdf_marketing` , ADD COLUMN `menu_subid_links` MEDIUMTEXT NOT NULL  AFTER `menu_keyword_links` , ADD COLUMN `menu_videos` MEDIUMTEXT NOT NULL  AFTER `menu_heading_training_materials` , ADD COLUMN `missing_security_code` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `pdf_bytes` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_description_1` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_description_2` MEDIUMTEXT NOT NULL  AFTER `pdf_description_1` , ADD COLUMN `pdf_file_description` MEDIUMTEXT NOT NULL  AFTER `pdf_description_2` , ADD COLUMN `pdf_file_name` MEDIUMTEXT NOT NULL  AFTER `pdf_description_2` , ADD COLUMN `pdf_file_size` MEDIUMTEXT NOT NULL  AFTER `pdf_file_name` , ADD COLUMN `pdf_marketing` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_title` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_training` MEDIUMTEXT NOT NULL  AFTER `pdf_title` , ADD COLUMN `peels_description` MEDIUMTEXT NOT NULL  AFTER `marketing_group` , ADD COLUMN `peels_title` MEDIUMTEXT NOT NULL  AFTER `marketing_group` , ADD COLUMN `peels_view` MEDIUMTEXT NOT NULL  AFTER `peels_title` , ADD COLUMN `signup_security_code` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `signup_security_info` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `signup_security_title` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `sub_tracking_build` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_example` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_build` , ADD COLUMN `sub_tracking_id` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_example` , ADD COLUMN `sub_tracking_info` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_none` MEDIUMTEXT NOT NULL  AFTER `signup_security_code` , ADD COLUMN `sub_tracking_title` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_tutorial` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_example` , CHANGE COLUMN `banners_size` `banners_size` MEDIUMTEXT NOT NULL  AFTER `marketing_group` ');
    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }
    try {
        $db->query('ALTER TABLE `idevaff_language_french` DROP COLUMN `ad_button` , DROP COLUMN `ad_choose` , DROP COLUMN `ad_group` , DROP COLUMN `ad_notice` , DROP COLUMN `ad_no_group` , DROP COLUMN `ad_source` , DROP COLUMN `banners_button` , DROP COLUMN `banners_choose` , DROP COLUMN `banners_group` , DROP COLUMN `banners_notice` , DROP COLUMN `banners_no_group` , DROP COLUMN `banners_source` , DROP COLUMN `custom_browse_link` , DROP COLUMN `custom_create_button` , DROP COLUMN `custom_define_info` , DROP COLUMN `custom_define_page` , DROP COLUMN `custom_disabled_info` , DROP COLUMN `custom_disabled_title` , DROP COLUMN `custom_incoming_info` , DROP COLUMN `custom_incoming_page` , DROP COLUMN `custom_info` , DROP COLUMN `custom_keyword` , DROP COLUMN `custom_remove_success` , DROP COLUMN `custom_success` , DROP COLUMN `custom_table_delete_link` , DROP COLUMN `custom_table_hits` , DROP COLUMN `custom_table_inactive` , DROP COLUMN `custom_table_link` , DROP COLUMN `custom_table_open_link` , DROP COLUMN `custom_table_page` , DROP COLUMN `custom_table_rate` , DROP COLUMN `custom_table_remove` , DROP COLUMN `custom_table_sales` , DROP COLUMN `custom_table_title` , DROP COLUMN `custom_title` , DROP COLUMN `custom_warning_exists` , DROP COLUMN `custom_warning_invalid` , DROP COLUMN `custom_warning_none` , DROP COLUMN `custom_warning_url_invalid` , DROP COLUMN `html_button` , DROP COLUMN `html_choose` , DROP COLUMN `html_group` , DROP COLUMN `html_notice` , DROP COLUMN `html_no_group` , DROP COLUMN `html_source` , DROP COLUMN `links_button` , DROP COLUMN `links_choose` , DROP COLUMN `links_group` , DROP COLUMN `links_notice` , DROP COLUMN `links_no_group` , DROP COLUMN `links_source` , ADD COLUMN `account_hidden` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `alternate_build` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_button` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_example` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_failed_info` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_failed_title` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_heading_1` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_info_1` MEDIUMTEXT NOT NULL  AFTER `alternate_heading_1` , ADD COLUMN `alternate_info_2` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_links_heading` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_links_note` MEDIUMTEXT NOT NULL  AFTER `alternate_links_heading` , ADD COLUMN `alternate_links_remove` MEDIUMTEXT NOT NULL  AFTER `alternate_links_note` , ADD COLUMN `alternate_none` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_option_1` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_option_2` MEDIUMTEXT NOT NULL  AFTER `alternate_links_remove` , ADD COLUMN `alternate_success_info` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_success_title` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_title` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_tutorial` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_variable` MEDIUMTEXT NOT NULL  AFTER `alternate_info_2` , ADD COLUMN `cr_button` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_detailed` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_export` MEDIUMTEXT NOT NULL  AFTER `cr_detailed` , ADD COLUMN `cr_found` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_none` MEDIUMTEXT NOT NULL  AFTER `cr_export` , ADD COLUMN `cr_no_results_info` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_no_results` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_select` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_times` MEDIUMTEXT NOT NULL  AFTER `cr_found` , ADD COLUMN `cr_title` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_unique` MEDIUMTEXT NOT NULL  AFTER `cr_times` , ADD COLUMN `cr_used` MEDIUMTEXT NOT NULL  AFTER `cr_no_results_info` , ADD COLUMN `etemplates_name` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `etemplates_title` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `etemplates_view_link` MEDIUMTEXT NOT NULL  AFTER `etemplates_title` , ADD COLUMN `excel_affiliate` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_comm_current` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_comm_paid` MEDIUMTEXT NOT NULL  AFTER `excel_comm_current` , ADD COLUMN `excel_comm_ratio` MEDIUMTEXT NOT NULL  AFTER `excel_comm_paid` , ADD COLUMN `excel_comm_stats` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_comm_total` MEDIUMTEXT NOT NULL  AFTER `excel_comm_paid` , ADD COLUMN `excel_criteria` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_date` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_earned_current` MEDIUMTEXT NOT NULL  AFTER `excel_comm_ratio` , ADD COLUMN `excel_earned_paid` MEDIUMTEXT NOT NULL  AFTER `excel_earned_current` , ADD COLUMN `excel_earned_tab` MEDIUMTEXT NOT NULL  AFTER `excel_earned_paid` , ADD COLUMN `excel_earned_total` MEDIUMTEXT NOT NULL  AFTER `excel_earned_paid` , ADD COLUMN `excel_earned` MEDIUMTEXT NOT NULL  AFTER `excel_comm_ratio` , ADD COLUMN `excel_hits` MEDIUMTEXT NOT NULL  AFTER `excel_criteria` , ADD COLUMN `excel_link` MEDIUMTEXT NOT NULL  AFTER `excel_criteria` , ADD COLUMN `excel_log_date` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_log_ip` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_log_refer` MEDIUMTEXT NOT NULL  AFTER `excel_log_ip` , ADD COLUMN `excel_log_target` MEDIUMTEXT NOT NULL  AFTER `excel_log_date` , ADD COLUMN `excel_log_time` MEDIUMTEXT NOT NULL  AFTER `excel_log_date` , ADD COLUMN `excel_log_title` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_tab_logs` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_tab_report` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_title` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `keyword_build` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_example` MEDIUMTEXT NOT NULL  AFTER `keyword_build` , ADD COLUMN `keyword_heading` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_info` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_title` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_tracking` MEDIUMTEXT NOT NULL  AFTER `keyword_heading` , ADD COLUMN `keyword_tutorial` MEDIUMTEXT NOT NULL  AFTER `keyword_example` , ADD COLUMN `lb_body_click` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_body_description` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_body_source_code` MEDIUMTEXT NOT NULL  AFTER `lb_body_click` , ADD COLUMN `lb_body_title` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_code_notes` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_description` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_source_code` MEDIUMTEXT NOT NULL  AFTER `lb_head_description` , ADD COLUMN `lb_head_title`
 MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_tutorial` MEDIUMTEXT NOT NULL  AFTER `lb_head_code_notes` , ADD COLUMN `logo_approved` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bad_filetype` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_browse` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bullet_one` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bullet_pixels` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_req_size_one` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_req_size_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_req_size_one` , ADD COLUMN `logo_bullet_size_one` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_size_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_size_one` , ADD COLUMN `logo_bullet_three` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_button` MEDIUMTEXT NOT NULL  AFTER `logo_browse` , ADD COLUMN `logo_choose` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_pixels` , ADD COLUMN `logo_current` MEDIUMTEXT NOT NULL  AFTER `logo_button` , ADD COLUMN `logo_display_status` MEDIUMTEXT NOT NULL  AFTER `logo_current` , ADD COLUMN `logo_error_bytes` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `logo_error_title` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `logo_file` MEDIUMTEXT NOT NULL  AFTER `logo_choose` , ADD COLUMN `logo_info` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_maximum_height` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_maximum_width` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_missing_filename` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_pending` MEDIUMTEXT NOT NULL  AFTER `logo_display_status` , ADD COLUMN `logo_remove` MEDIUMTEXT NOT NULL  AFTER `logo_current` , ADD COLUMN `logo_required_height` MEDIUMTEXT NOT NULL  AFTER `logo_missing_filename` , ADD COLUMN `logo_required_width` MEDIUMTEXT NOT NULL  AFTER `logo_missing_filename` , ADD COLUMN `logo_size_maximum` MEDIUMTEXT NOT NULL  AFTER `logo_maximum_height` , ADD COLUMN `logo_success` MEDIUMTEXT NOT NULL  AFTER `logo_approved` , ADD COLUMN `logo_title` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_upload_error` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `marketing_group` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `marketing_source_code` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `marketing_target_url` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `menu_alteranate_links` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_custom_manual` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_custom_reports` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_drop_change` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_current` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_edit` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_general_stats` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_account` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_commissions` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_faq` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_account` , ADD COLUMN `menu_drop_heading_history` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_commissions` , ADD COLUMN `menu_drop_heading_logo` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_account` , ADD COLUMN `menu_drop_heading_stats` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_traffic` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_history` , ADD COLUMN `menu_drop_paid_rec` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_paid` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_password` MEDIUMTEXT NOT NULL  AFTER `menu_drop_edit` , ADD COLUMN `menu_drop_pending` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_recurring` MEDIUMTEXT NOT NULL  AFTER `menu_drop_paid_rec` , ADD COLUMN `menu_drop_tier_stats` MEDIUMTEXT NOT NULL  AFTER `menu_drop_general_stats` , ADD COLUMN `menu_drop_tier` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_email_templates` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_heading_additional` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_heading_custom_links` MEDIUMTEXT NOT NULL  AFTER `menu_email_templates` , ADD COLUMN `menu_heading_training_materials` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_keyword_links` MEDIUMTEXT NOT NULL  AFTER `menu_custom_reports` , ADD COLUMN `menu_lightboxes` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_page_peels` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_pdf_marketing` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `menu_pdf_training` MEDIUMTEXT NOT NULL  AFTER `menu_pdf_marketing` , ADD COLUMN `menu_subid_links` MEDIUMTEXT NOT NULL  AFTER `menu_keyword_links` , ADD COLUMN `menu_videos` MEDIUMTEXT NOT NULL  AFTER `menu_heading_training_materials` , ADD COLUMN `missing_security_code` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `pdf_bytes` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_description_1` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_description_2` MEDIUMTEXT NOT NULL  AFTER `pdf_description_1` , ADD COLUMN `pdf_file_description` MEDIUMTEXT NOT NULL  AFTER `pdf_description_2` , ADD COLUMN `pdf_file_name` MEDIUMTEXT NOT NULL  AFTER `pdf_description_2` , ADD COLUMN `pdf_file_size` MEDIUMTEXT NOT NULL  AFTER `pdf_file_name` , ADD COLUMN `pdf_marketing` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_title` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_training` MEDIUMTEXT NOT NULL  AFTER `pdf_title` , ADD COLUMN `peels_description` MEDIUMTEXT NOT NULL  AFTER `marketing_group` , ADD COLUMN `peels_title` MEDIUMTEXT NOT NULL  AFTER `marketing_group` , ADD COLUMN `peels_view` MEDIUMTEXT NOT NULL  AFTER `peels_title` , ADD COLUMN `signup_security_code` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `signup_security_info` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `signup_security_title` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `sub_tracking_build` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_example` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_build` , ADD COLUMN `sub_tracking_id` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_example` , ADD COLUMN `sub_tracking_info` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_none` MEDIUMTEXT NOT NULL  AFTER `signup_security_code` , ADD COLUMN `sub_tracking_title` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_tutorial` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_example` , CHANGE COLUMN `banners_size` `banners_size` MEDIUMTEXT NOT NULL  AFTER `marketing_group` ');
    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }
    try {
        $db->query('ALTER TABLE `idevaff_language_italian` DROP COLUMN `ad_button` , DROP COLUMN `ad_choose` , DROP COLUMN `ad_group` , DROP COLUMN `ad_notice` , DROP COLUMN `ad_no_group` , DROP COLUMN `ad_source` , DROP COLUMN `banners_button` , DROP COLUMN `banners_choose` , DROP COLUMN `banners_group` , DROP COLUMN `banners_notice` , DROP COLUMN `banners_no_group` , DROP COLUMN `banners_source` , DROP COLUMN `custom_browse_link` , DROP COLUMN `custom_create_button` , DROP COLUMN `custom_define_info` , DROP COLUMN `custom_define_page` , DROP COLUMN `custom_disabled_info` , DROP COLUMN `custom_disabled_title` , DROP COLUMN `custom_incoming_info` , DROP COLUMN `custom_incoming_page` , DROP COLUMN `custom_info` , DROP COLUMN `custom_keyword` , DROP COLUMN `custom_remove_success` , DROP COLUMN `custom_success` , DROP COLUMN `custom_table_delete_link` , DROP COLUMN `custom_table_hits` , DROP COLUMN `custom_table_inactive` , DROP COLUMN `custom_table_link` , DROP COLUMN `custom_table_open_link` , DROP COLUMN `custom_table_page` , DROP COLUMN `custom_table_rate` , DROP COLUMN `custom_table_remove` , DROP COLUMN `custom_table_sales` , DROP COLUMN `custom_table_title` , DROP COLUMN `custom_title` , DROP COLUMN `custom_warning_exists` , DROP COLUMN `custom_warning_invalid` , DROP COLUMN `custom_warning_none` , DROP COLUMN `custom_warning_url_invalid` , DROP COLUMN `html_button` , DROP COLUMN `html_choose` , DROP COLUMN `html_group` , DROP COLUMN `html_notice` , DROP COLUMN `html_no_group` , DROP COLUMN `html_source` , DROP COLUMN `links_button` , DROP COLUMN `links_choose` , DROP COLUMN `links_group` , DROP COLUMN `links_notice` , DROP COLUMN `links_no_group` , DROP COLUMN `links_source` , ADD COLUMN `account_hidden` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `alternate_build` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_button` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_example` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_failed_info` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_failed_title` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_heading_1` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_info_1` MEDIUMTEXT NOT NULL  AFTER `alternate_heading_1` , ADD COLUMN `alternate_info_2` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_links_heading` MEDIUMTEXT NOT NULL  AFTER `alternate_button` , ADD COLUMN `alternate_links_note` MEDIUMTEXT NOT NULL  AFTER `alternate_links_heading` , ADD COLUMN `alternate_links_remove` MEDIUMTEXT NOT NULL  AFTER `alternate_links_note` , ADD COLUMN `alternate_none` MEDIUMTEXT NOT NULL  AFTER `alternate_build` , ADD COLUMN `alternate_option_1` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_option_2` MEDIUMTEXT NOT NULL  AFTER `alternate_links_remove` , ADD COLUMN `alternate_success_info` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_success_title` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_title` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `alternate_tutorial` MEDIUMTEXT NOT NULL  AFTER `alternate_none` , ADD COLUMN `alternate_variable` MEDIUMTEXT NOT NULL  AFTER `alternate_info_2` , ADD COLUMN `cr_button` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_detailed` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_export` MEDIUMTEXT NOT NULL  AFTER `cr_detailed` , ADD COLUMN `cr_found` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_none` MEDIUMTEXT NOT NULL  AFTER `cr_export` , ADD COLUMN `cr_no_results_info` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_no_results` MEDIUMTEXT NOT NULL  AFTER `cr_button` , ADD COLUMN `cr_select` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_times` MEDIUMTEXT NOT NULL  AFTER `cr_found` , ADD COLUMN `cr_title` MEDIUMTEXT NOT NULL  AFTER `alternate_tutorial` , ADD COLUMN `cr_unique` MEDIUMTEXT NOT NULL  AFTER `cr_times` , ADD COLUMN `cr_used` MEDIUMTEXT NOT NULL  AFTER `cr_no_results_info` , ADD COLUMN `etemplates_name` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `etemplates_title` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `etemplates_view_link` MEDIUMTEXT NOT NULL  AFTER `etemplates_title` , ADD COLUMN `excel_affiliate` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_comm_current` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_comm_paid` MEDIUMTEXT NOT NULL  AFTER `excel_comm_current` , ADD COLUMN `excel_comm_ratio` MEDIUMTEXT NOT NULL  AFTER `excel_comm_paid` , ADD COLUMN `excel_comm_stats` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_comm_total` MEDIUMTEXT NOT NULL  AFTER `excel_comm_paid` , ADD COLUMN `excel_criteria` MEDIUMTEXT NOT NULL  AFTER `excel_affiliate` , ADD COLUMN `excel_date` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_earned_current` MEDIUMTEXT NOT NULL  AFTER `excel_comm_ratio` , ADD COLUMN `excel_earned_paid` MEDIUMTEXT NOT NULL  AFTER `excel_earned_current` , ADD COLUMN `excel_earned_tab` MEDIUMTEXT NOT NULL  AFTER `excel_earned_paid` , ADD COLUMN `excel_earned_total` MEDIUMTEXT NOT NULL  AFTER `excel_earned_paid` , ADD COLUMN `excel_earned` MEDIUMTEXT NOT NULL  AFTER `excel_comm_ratio` , ADD COLUMN `excel_hits` MEDIUMTEXT NOT NULL  AFTER `excel_criteria` , ADD COLUMN `excel_link` MEDIUMTEXT NOT NULL  AFTER `excel_criteria` , ADD COLUMN `excel_log_date` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_log_ip` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_log_refer` MEDIUMTEXT NOT NULL  AFTER `excel_log_ip` , ADD COLUMN `excel_log_target` MEDIUMTEXT NOT NULL  AFTER `excel_log_date` , ADD COLUMN `excel_log_time` MEDIUMTEXT NOT NULL  AFTER `excel_log_date` , ADD COLUMN `excel_log_title` MEDIUMTEXT NOT NULL  AFTER `excel_earned_tab` , ADD COLUMN `excel_tab_logs` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_tab_report` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `excel_title` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `keyword_build` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_example` MEDIUMTEXT NOT NULL  AFTER `keyword_build` , ADD COLUMN `keyword_heading` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_info` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_title` MEDIUMTEXT NOT NULL  AFTER `account_hidden` , ADD COLUMN `keyword_tracking` MEDIUMTEXT NOT NULL  AFTER `keyword_heading` , ADD COLUMN `keyword_tutorial` MEDIUMTEXT NOT NULL  AFTER `keyword_example` , ADD COLUMN `lb_body_click` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_body_description` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_body_source_code` MEDIUMTEXT NOT NULL  AFTER `lb_body_click` , ADD COLUMN `lb_body_title` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_code_notes` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_description` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_source_code` MEDIUMTEXT NOT NULL  AFTER `lb_head_description` , ADD COLUMN `lb_head_title`
 MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `lb_head_tutorial` MEDIUMTEXT NOT NULL  AFTER `lb_head_code_notes` , ADD COLUMN `logo_approved` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bad_filetype` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_browse` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bullet_one` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_bullet_pixels` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_req_size_one` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_req_size_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_req_size_one` , ADD COLUMN `logo_bullet_size_one` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_size_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_size_one` , ADD COLUMN `logo_bullet_three` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_bullet_two` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_one` , ADD COLUMN `logo_button` MEDIUMTEXT NOT NULL  AFTER `logo_browse` , ADD COLUMN `logo_choose` MEDIUMTEXT NOT NULL  AFTER `logo_bullet_pixels` , ADD COLUMN `logo_current` MEDIUMTEXT NOT NULL  AFTER `logo_button` , ADD COLUMN `logo_display_status` MEDIUMTEXT NOT NULL  AFTER `logo_current` , ADD COLUMN `logo_error_bytes` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `logo_error_title` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `logo_file` MEDIUMTEXT NOT NULL  AFTER `logo_choose` , ADD COLUMN `logo_info` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_maximum_height` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_maximum_width` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_missing_filename` MEDIUMTEXT NOT NULL  AFTER `alternate_failed_info` , ADD COLUMN `logo_pending` MEDIUMTEXT NOT NULL  AFTER `logo_display_status` , ADD COLUMN `logo_remove` MEDIUMTEXT NOT NULL  AFTER `logo_current` , ADD COLUMN `logo_required_height` MEDIUMTEXT NOT NULL  AFTER `logo_missing_filename` , ADD COLUMN `logo_required_width` MEDIUMTEXT NOT NULL  AFTER `logo_missing_filename` , ADD COLUMN `logo_size_maximum` MEDIUMTEXT NOT NULL  AFTER `logo_maximum_height` , ADD COLUMN `logo_success` MEDIUMTEXT NOT NULL  AFTER `logo_approved` , ADD COLUMN `logo_title` MEDIUMTEXT NOT NULL  AFTER `cr_none` , ADD COLUMN `logo_upload_error` MEDIUMTEXT NOT NULL  AFTER `logo_bad_filetype` , ADD COLUMN `marketing_group` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `marketing_source_code` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `marketing_target_url` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `menu_alteranate_links` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_custom_manual` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_custom_reports` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_drop_change` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_current` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_edit` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_general_stats` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_account` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_commissions` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_faq` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_account` , ADD COLUMN `menu_drop_heading_history` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_commissions` , ADD COLUMN `menu_drop_heading_logo` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_account` , ADD COLUMN `menu_drop_heading_stats` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_drop_heading_traffic` MEDIUMTEXT NOT NULL  AFTER `menu_drop_heading_history` , ADD COLUMN `menu_drop_paid_rec` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_paid` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_password` MEDIUMTEXT NOT NULL  AFTER `menu_drop_edit` , ADD COLUMN `menu_drop_pending` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_drop_recurring` MEDIUMTEXT NOT NULL  AFTER `menu_drop_paid_rec` , ADD COLUMN `menu_drop_tier_stats` MEDIUMTEXT NOT NULL  AFTER `menu_drop_general_stats` , ADD COLUMN `menu_drop_tier` MEDIUMTEXT NOT NULL  AFTER `menu_drop_current` , ADD COLUMN `menu_email_templates` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_heading_additional` MEDIUMTEXT NOT NULL  AFTER `menu_alteranate_links` , ADD COLUMN `menu_heading_custom_links` MEDIUMTEXT NOT NULL  AFTER `menu_email_templates` , ADD COLUMN `menu_heading_training_materials` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `menu_keyword_links` MEDIUMTEXT NOT NULL  AFTER `menu_custom_reports` , ADD COLUMN `menu_lightboxes` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_page_peels` MEDIUMTEXT NOT NULL  AFTER `menu_custom_manual` , ADD COLUMN `menu_pdf_marketing` MEDIUMTEXT NOT NULL  AFTER `invoice_aff_user` , ADD COLUMN `menu_pdf_training` MEDIUMTEXT NOT NULL  AFTER `menu_pdf_marketing` , ADD COLUMN `menu_subid_links` MEDIUMTEXT NOT NULL  AFTER `menu_keyword_links` , ADD COLUMN `menu_videos` MEDIUMTEXT NOT NULL  AFTER `menu_heading_training_materials` , ADD COLUMN `missing_security_code` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `pdf_bytes` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_description_1` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_description_2` MEDIUMTEXT NOT NULL  AFTER `pdf_description_1` , ADD COLUMN `pdf_file_description` MEDIUMTEXT NOT NULL  AFTER `pdf_description_2` , ADD COLUMN `pdf_file_name` MEDIUMTEXT NOT NULL  AFTER `pdf_description_2` , ADD COLUMN `pdf_file_size` MEDIUMTEXT NOT NULL  AFTER `pdf_file_name` , ADD COLUMN `pdf_marketing` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_title` MEDIUMTEXT NOT NULL  AFTER `lb_body_source_code` , ADD COLUMN `pdf_training` MEDIUMTEXT NOT NULL  AFTER `pdf_title` , ADD COLUMN `peels_description` MEDIUMTEXT NOT NULL  AFTER `marketing_group` , ADD COLUMN `peels_title` MEDIUMTEXT NOT NULL  AFTER `marketing_group` , ADD COLUMN `peels_view` MEDIUMTEXT NOT NULL  AFTER `peels_title` , ADD COLUMN `signup_security_code` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `signup_security_info` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `signup_security_title` MEDIUMTEXT NOT NULL  AFTER `logo_success` , ADD COLUMN `sub_tracking_build` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_example` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_build` , ADD COLUMN `sub_tracking_id` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_example` , ADD COLUMN `sub_tracking_info` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_none` MEDIUMTEXT NOT NULL  AFTER `signup_security_code` , ADD COLUMN `sub_tracking_title` MEDIUMTEXT NOT NULL  AFTER `keyword_tutorial` , ADD COLUMN `sub_tracking_tutorial` MEDIUMTEXT NOT NULL  AFTER `sub_tracking_example` , CHANGE COLUMN `banners_size` `banners_size` MEDIUMTEXT NOT NULL  AFTER `marketing_group` ');
    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }
}


try {
    $db->query('ALTER TABLE `idevaff_sales` ADD COLUMN `delay` INT(10) NOT NULL DEFAULT \'0\'  AFTER `profile` , ADD COLUMN `referring_url` VARCHAR(255) NOT NULL DEFAULT \'\'  AFTER `delay` , ADD COLUMN `sub_id` VARCHAR(64) NOT NULL  AFTER `aff_alert` , ADD COLUMN `target_url` VARCHAR(255) NOT NULL  AFTER `sub_id` , ADD COLUMN `tid1` VARCHAR(64) NOT NULL  AFTER `sub_id` , ADD COLUMN `tid2` VARCHAR(64) NOT NULL  AFTER `tid1` , ADD COLUMN `tid3` VARCHAR(64) NOT NULL  AFTER `tid2` , ADD COLUMN `tid4` VARCHAR(64) NOT NULL  AFTER `tid3` , CHANGE COLUMN `payment` `payment` DECIMAL(20,2) NOT NULL DEFAULT \'0.00\'  , CHANGE COLUMN `amount` `amount` DECIMAL(20,2) NOT NULL DEFAULT \'0.00\' ');
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

// -----------
// UPDATE DATA
// -----------

$checkdata = $db->query("select link_style from idevaff_config");
if ( $checkdata->rowCount() > 0 ) {
    $checkdata = $checkdata->fetch();
    $link_style = $checkdata['link_style'];
    if ($link_style == 0) {
        $db->query("update idevaff_config set link_style = '1'");
    }
}

try {
    $db->query("update idevaff_config set panel_width = '900'");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("update idevaff_config set page_style = ''");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("update idevaff_config set flashcab = '9,0,0,0'");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

// CHECK GD & FREETYPE STATUS
// --------------------------------------
$use_sec_enable = 0;
if (extension_loaded('gd') && function_exists('gd_info')) {
    $arr_gd_info = gd_info();
    if($arr_gd_info['FreeType Support'] == true) {
        $use_sec_enable = 1;
    }
}
try {
    $db_update = $db->prepare("update idevaff_config set use_security = ?");
    $db_update->execute(array($use_sec_enable));
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {
    $db->query("update idevaff_config set ip_setting = 'REMOTE_ADDR'");

} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("update idevaff_config set admin_notify_logo = '1'");

} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("update idevaff_config set affiliate_notify_logo = '1'");

} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("update idevaff_config set affiliate_notify_unapproved = '1'");

} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("update idevaff_config set bk_image = 'images/trans_no_background.png'");

} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("update idevaff_config set lightbox_link_text = 'Click here to visit our website!'");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("update idevaff_config set account_notify_affiliate_approved = '1'");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}
try {
    $db->query("update idevaff_config set allow_alternate = '1'");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}


$checkdata = $db->query("select * from idevaff_delayed");
$checkdata = $checkdata->rowCount();
if (!$checkdata) {
    try {
        $db->query("insert into idevaff_delayed VALUES (0, 90, 0)");
    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }

}

$checkdata = $db->query("select * from idevaff_lightboxes");
$checkdata = $checkdata->rowCount();
if (!$checkdata) {
    try {
        $db->query("insert into idevaff_lightboxes VALUES (1, 1, 'Sample Lightbox', 'sample_small.jpg', 'sample_large.jpg', 'This is just a sample lightbox.', 0, 0)");
    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }

}

$checkdata = $db->query("select * from idevaff_logo_settings");
$checkdata = $checkdata->rowCount();
if (!$checkdata) {
    try {
        $db->query("insert into idevaff_logo_settings VALUES (0, '10000', '250', '250', 0, 'http://www.yoursite.com/idevaffiliate/logos/idevaffiliate.jpg')");
    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }

}

$checkdata = $db->query("select * from idevaff_pdf");
$checkdata = $checkdata->rowCount();
if (!$checkdata) {
    try {
        $db->query("insert into idevaff_pdf VALUES (1, 'sample-marketing.pdf', '1', '39571', 'Example PDF brochure.')");
    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }
    try {
        $db->query("insert into idevaff_pdf VALUES (2, 'sample-training.pdf', '2', '39238', 'Example training document.')");
    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }
}

$checkdata = $db->query("select * from idevaff_peels");
$checkdata = $checkdata->rowCount();
if (!$checkdata) {
    try {
        $db->query("insert into idevaff_peels VALUES (0, 1, 'Sample Page Peel', 'peel-small.jpg', 'peel-large.jpg', 'Sample page peel.', 0, 0)");
    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }
}

$checkdata = $db->query("select * from idevaff_training_videos");
$checkdata = $checkdata->rowCount();
if (!$checkdata) {
    if (function_exists("curl_init")) {
        $vid_en = 1;
    } else {
        $vid_en = 0;
    }
    try {
        $db->query("insert into idevaff_training_videos VALUES ($vid_en, '', '', '', '', '')");
    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }
}

try {
    $db->query("UPDATE idevaff_email SET admin_fail_subject = 'Commission Failure on Whatever', admin_fail_body = 'Dear Admin,\r\n\r\niDevAffiliate tried processing a commission and failed.  You will only receive this message if you chose not to approve commissions in the admin center.  This commission was not written to the database due to one of the following reasons.\r\n\r\nA.) iDevAffiliate didn\'t receive the sale amount.\r\nB.) The commission amount was to low to calculate.\r\nC.) Your cart integration is not setup properly.\r\n\r\nCheck your Cart Integration, Processing Code Placement or make sure the sale amount was large enough to perform a percentage calculation on.', login_subject = 'Our Affiliate Program Login Details', login_body = 'Dear _firstname_,\r\n\r\nYour requested login information is below.\r\n\r\nUsername: _username_\r\nPassword: _password_\r\n\r\nLogin Here:\r\n_loginpage_', admin_notify_logo_sub = 'New Image Upload on Whatever', admin_notify_logo_body = 'Dear Admin,\r\n\r\nAn image/logo has been uploaded by an affiliate and it requires your approval.  Please login your iDevAffiliate admin center to approve or decline this image.', aff_img_app_sub = 'Whatever Affiliate Program Image Upload Approval', aff_img_app_body = 'Dear _username_,\r\n\r\nWe are pleased to inform you that we have approved your recent image/logo upload.  Your logo will now be used on our website and your affiliates will see it when you deliver them through your affiliate link.', aff_img_dec_sub = 'Whatever Affiliate Program Image Upload Declined', aff_img_dec_body = 'Dear _username_,\r\n\r\nWe are sorry to inform you that we have been unable to approve your recent image/logo upload.  If you have any questions, please feel free to contact us.', aff_unapprove_sub = 'Whatever Commission Removed', aff_unapprove_body = 'Dear _username_,\r\n\r\nWe\'re sorry to inform you that we\'ve had to remove a previously approved commission from your account.  This is due to one of the following reasons.\r\n\r\n- The customer requested a refund.\r\n- The sale turned out to be fraudulent.\r\n- The customer\'s credit card was declined.\r\n\r\nWe appreciate your understanding in this matter.'");
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}

try {
    $db->query("UPDATE idevaff_language_english SET menu_pdf_marketing = 'PDF Marketing Brochures',menu_pdf_training = 'PDF Training Documents',marketing_target_url = 'Target URL',marketing_source_code = 'Source Code - Copy/Paste Into Your Website',marketing_group = 'Marketing Group',banners_size = 'Banner Size',peels_title = 'Page Peel Name',peels_view = 'View This Peel',peels_description = 'Page Peel Description',lb_head_title = 'Required HEAD Code For Your HTML Page',lb_head_description = 'In order to use a lightbox on your website, you must add the following lines to the head section of the page you want it displayed.',lb_head_source_code = 'Paste this code into the HEAD section of your HTML document.',lb_head_code_notes = 'You only need to place this code one time no matter how many lightboxes you place on the page.',lb_head_tutorial = 'View Tutorial',lb_body_title = 'Lightbox Name',lb_body_description = 'Lightbox Description',lb_body_click = 'Click the above image to view the lightbox.',lb_body_source_code = 'Paste this code into the BODY section of your HTML document where you want the image to appear.',pdf_title = 'PDF',pdf_training = 'Training Documents',pdf_marketing = 'Marketing Brochures',pdf_description_1 = 'Adobe Reader is required to view and print our PDF marketing materials.',pdf_description_2 = 'Adobe Reader is a free download from the Adobe website.',pdf_file_name = 'File Name',pdf_file_size = 'File Size',pdf_file_description = 'Description',pdf_bytes = 'Bytes',menu_heading_training_materials = 'Training Materials',menu_videos = 'Watch Training Videos',menu_custom_manual = 'Custom Tracking Links Manual',menu_page_peels = 'Page Peels',menu_lightboxes = 'Lightboxes',menu_email_templates = 'Email Templates',menu_heading_custom_links = 'Custom Tracking Links',menu_custom_reports = 'Reports',menu_keyword_links = 'Keyword Tracking Links',menu_subid_links = 'Sub-Affiliate Tracking Links',menu_alteranate_links = 'Alternate Incoming Page Links',menu_heading_additional = 'Additional Tools',menu_drop_heading_stats = 'General Stats',menu_drop_heading_commissions = 'Commissions',menu_drop_heading_history = 'Payment History',menu_drop_heading_traffic = 'Traffic Log',menu_drop_heading_account = 'My Account',menu_drop_heading_logo = 'Upload My Logo',menu_drop_heading_faq = 'FAQ',menu_drop_general_stats = 'General Statistics',menu_drop_tier_stats = 'Tier Statistics',menu_drop_current = 'Current Commissions',menu_drop_tier = 'Current Tier Commissions',menu_drop_pending = 'Pending Approval',menu_drop_paid = 'Paid Commissions',menu_drop_paid_rec = 'Paid Tier Commissions',menu_drop_recurring = 'Active Recurring Commissions',menu_drop_edit = 'Edit My Account',menu_drop_password = 'Change My Password',menu_drop_change = 'Change My Commission Style',account_hidden = 'hidden',keyword_title = 'Custom Keyword Links',keyword_info = 'Creating a custom keyword link provides you the ability to track incoming traffic for various sources.  Create a link with up to 4 different tracking keywords and the custom tracking report will show you a detailed report for each keyword you create.',keyword_heading = 'Available Variables For Custom Keyword Tracking',keyword_tracking = 'Tracking ID',keyword_build = 'To build your link, take the following URL and append it with the Tracking ID and keyword you want to use.',keyword_example = 'Example',keyword_tutorial = 'View The Tutorial',sub_tracking_title = 'Sub-Affiliate Tracking',sub_tracking_info = 'Creating a sub-affiliate link provides you the ability to pass your affiliate link out to your own affiliates for them to use. You will know who generated the commission for you because we will report to you which of your sub-affiliates generated the sale. Another reason to use a sub-affiliate link is if you have your own tracking system you want included for reporting.',sub_tracking_build = 'Replace the XXX with the affiliate\'s ID number in your affiliate program.  Repeat this process for all your affiliates.',sub_tracking_example = 'Example',sub_tracking_tutorial = 'View Tutorial',sub_tracking_id = 'Sub-Affiliate ID',alternate_title = 'Alternate Incoming Page Links',alternate_option_1 = 'Option 1: Automated Link Creation',alternate_heading_1 = 'Automated Link Creation',
 alternate_info_1 = 'Define your own incoming traffic page by entering the URL you want traffic delivered to and we\'ll create a link for you. Using this feature will create a shorter link for you to use with the URL embedded in the link using an ID number in our database.',alternate_button = 'Create My Link',alternate_links_heading = 'My Alternate Incoming URL Links',alternate_links_note = 'Existing links will remain in tact and functional if you remove a custom link from this page.',alternate_links_remove = 'remove',alternate_option_2 = 'Option 2: Manual Link Creation',alternate_info_2 = 'If you\'d prefer to append your own affiliate links with an alternate incoming URL, use the following structure.',alternate_variable = 'Alternate Incoming URL Variable',alternate_example = 'Example',alternate_build = 'To build your link, take the following URL and append it with the Alternate Incoming URL you want to use.',alternate_none = 'No Alternate Incoming Links Created',alternate_tutorial = 'View Tutorial',cr_title = 'Custom Keyword Report',cr_select = 'Select A Keyword',cr_button = 'Generate Report',cr_no_results = 'No Search Results Found',cr_no_results_info = 'Try A Different Keyword Combination',cr_used = 'Keywords Used',cr_found = 'This Link Found',cr_times = 'Times',cr_unique = 'Unique Links Found',cr_detailed = 'Detailed Link Report',cr_export = 'Export Report To Excel',cr_none = 'No Keywords Found',logo_title = 'Upload Your Company Logo',logo_info = 'If you would like to upload your Company logo, we will display it to customers you deliver to our website.  This allows us to personalize your customer\'s experience when they visit us.',logo_bullet_one = 'Images may be .jpg, .gif or .png.  No flash content is allowed.',logo_bullet_two = 'Any inappropriate images will be discarded and your account suspended.',logo_bullet_three = 'Your image/logo will not be shown on our website until we\'ve approved it.',logo_bullet_size_one = 'Images may have a maximum width of',logo_bullet_size_two = 'pixels and a maximum height of',logo_bullet_req_size_one = 'Images must have a width of',logo_bullet_req_size_two = 'pixels and a height of',logo_bullet_pixels = 'pixels.',logo_choose = 'Choose An Image',logo_file = 'Select A File:',logo_browse = 'Browse...',logo_button = 'Upload',logo_current = 'My Current Image',logo_remove = 'remove',logo_display_status = 'Image Status:',logo_pending = 'Pending Approval',logo_approved = 'Approved',logo_success = 'Image was successfully uploaded and is now pending approval.',signup_security_title = 'Account Verification',signup_security_info = 'Please enter the security code shown in the box.  This step helps us to prevent automated signups.',signup_security_code = 'Security Code',sub_tracking_none = 'None',missing_security_code = 'Incorrect or Missing Account Verification / Security Code',alternate_success_title = 'Link Creation Success',alternate_success_info = 'Grab your link below and start delivering traffic to your defined URL.',
 alternate_failed_title = 'Link Creation Error',alternate_failed_info = 'Please enter a valid URL.',logo_missing_filename = 'Please choose a filename.',logo_required_width = 'Image width must be',logo_required_height = 'Image height must be',logo_maximum_width = 'Image width can only be',logo_maximum_height = 'Image height can only be',logo_size_maximum = 'Image size can only be a maximum of',logo_bad_filetype = 'Image type is not allowed. Allowed image types are .gif, .jpg and .png.',logo_upload_error = 'Image upload error, please contact the affiliate manager.',logo_error_title = 'Image Upload Error',logo_error_bytes = 'bytes.',excel_title = 'Custom Keyword Links Report',excel_tab_report = 'Custom Keyword Report',excel_tab_logs = 'Traffic Logs',excel_date = 'Report Date:',excel_affiliate = 'Affiliate ID:',excel_criteria = 'Keyword Link Criteria',excel_link = 'Link Structure',excel_hits = 'Unique Hits',excel_comm_stats = 'Commission Statistics',excel_comm_current = 'Current Commissions',excel_comm_paid = 'Paid Commissions',excel_comm_total = 'Total Commissions',excel_comm_ratio = 'Conversion Ratio',excel_earned = 'Commissions Earned',excel_earned_current = 'Current Commissions',excel_earned_paid = 'Paid Commissions',excel_earned_total = 'Total Commissions Earned',excel_earned_tab = 'Click the Traffic Logs tab (below) to view the traffic log for this custom link.',excel_log_title = 'Custom Keywords Traffic Log',excel_log_ip = 'IP Address',excel_log_refer = 'Referring URL',excel_log_date = 'Date',excel_log_time = 'Time',excel_log_target = 'Target URL',etemplates_title = 'Email Templates',etemplates_view_link = 'View This Email Template',etemplates_name = 'Template Name'");

} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}


// UPDATE GOLD/PLATINUM/SEO WITH LANGUAGE ITEMS
$checkifplatplus = $db->query("select id from idevaff_language_packs");
if ($checkifplatplus->rowCount() > 1) {
    try {
        $db->query("UPDATE idevaff_language_german SET menu_pdf_marketing = 'PDF-Marketingbrosch�ren',menu_pdf_training = 'PDF-Schulungsunterlagen',marketing_target_url = 'Ziel-URL',marketing_source_code = 'Quellcode - In Ihre Webseite kopieren/einf�gen',marketing_group = 'Marketinggruppe',peels_title = 'Name des Page Peels',peels_view = 'Dieses Peel ansehen',peels_description = 'Beschreibung des Peels',lb_head_title = 'Erforderlicher HEAD Code f�r Ihre HTML-Seite',lb_head_description = 'Um eine Lightbox auf Ihrer Webseite zu verwenden, m�ssen Sie dem OBEREN Abschnitt jener Seite, auf der es angezeigt werden soll, folgende Zeilen hinzuf�gen.',lb_head_source_code = 'F�gen Sie diesen Code in den OBEREN Abschnitt Ihres HTML-Dokumentes.',lb_head_code_notes = 'Sie m�ssen diesen Code unabh�ngig von der geplanten Anzahl der Lightboxen auf Ihrer Seite ein Mal eingeben.',lb_head_tutorial = 'Anleitung ansehen',lb_body_title = 'Name der Lightbox',lb_body_description = 'Beschreibung der Lightbox',lb_body_click = 'Klicken Sie aufs obere Bild, um die Lightbox zu sehen',lb_body_source_code = 'F�gen Sie diesen Code in den HAUPTTEIL Ihres HTML-Dokuments dort ein, wo Sie das Bild platzieren m�chten.',pdf_title = 'PDF',pdf_training = 'Schulungsunterlagen',pdf_marketing = 'Marketingbrosch�ren',pdf_description_1 = 'Um sich unser PDF-Marketingmaterial ansehen zu k�nnen, ben�tigen Sie Adobe Reader.',pdf_description_2 = 'Adobe Reader kann kostenlos von der Adobe Webseite heruntergeladen werden.',pdf_file_name = 'Dateiname',pdf_file_size = 'Dateigr��e',pdf_file_description = 'Beschreibung',pdf_bytes = 'Bytes',menu_heading_training_materials = 'Schulungsunterlagen',menu_videos = 'Schulungsvideos ansehen',menu_custom_manual = 'Handbuch zur kundenspezifischen Verfolgung von Links',menu_page_peels = 'Page Peels',menu_lightboxes = 'Lightboxen',menu_email_templates = 'E-Mail-Vorlagen',menu_heading_custom_links = 'Kundenspezifisches Verfolgen von Links',menu_custom_reports = 'Berichte',menu_keyword_links = 'Schl�sselwort Links verfolgen',menu_subid_links = 'Verfolgungs-Links von Sub-Partnern',menu_alteranate_links = 'Einlaufende Seiten-Links abwechseln',menu_heading_additional = 'Zus�tzliche Tools',menu_drop_heading_stats = 'Allgemeine Statistiken',menu_drop_heading_commissions = 'Kommissionen',menu_drop_heading_history = 'Zahlungsverhalten',menu_drop_heading_traffic = 'Verkehrsprotokoll',menu_drop_heading_account = 'Mein Konto',menu_drop_heading_logo = 'Mein Logo hochladen',menu_drop_heading_faq = 'FAQ (H�ufig gestellte Fragen)',menu_drop_general_stats = 'Allgemeine Statistiken',menu_drop_tier_stats = 'Statistiken nach Stufe',menu_drop_current = 'Aktuelle Kommissionen',menu_drop_tier = 'Aktuelle Kommissionen nach Stufe',menu_drop_pending = 'Schwebende Freigabe',menu_drop_paid = 'Bezahlte Freigabe',menu_drop_paid_rec = 'Bezahlte Kommissionen nach Stufe',menu_drop_recurring = 'Aktive, wiederkehrende Kommissionen',menu_drop_edit = 'Mein Konto bearbeiten',menu_drop_password = 'Mein Passwort �ndern',menu_drop_change = 'Meine Kommissionsart �ndern',account_hidden = 'Versteckt',keyword_title = 'Links zu Schl�sselw�rtern',keyword_info = 'Die Erstellung eines Links zu einem Schl�sselwort erm�glicht Ihnen das Verfolgen eingehenden Verkehrs f�r unterschiedliche Quellen. Sie k�nnen einen Link mit bis zu vier unterschiedlichen Schl�sselw�rtern erstellen und der Verfolgungsbericht wird Ihnen einen detailierten Bericht zu jedem von Ihnen erstellten Schl�sselwort zeigen.',keyword_heading = 'Verf�gbare Variablen zur Verfolgung von Schl�sselw�rtern',keyword_tracking = 'Verfolgungsnummer',keyword_build = 'Um Ihren Link zu erstellen, nehmen Sie den folgenden URL und verbinden Sie ihn mit der von Ihnen gew�nschten Verfolgungsnummer und dem Schl�sselwort.',keyword_example = 'Beispiel',keyword_tutorial = 'Die Anleitung ansehen',sub_tracking_title = 'Verfolgung von Sub-Partnern',sub_tracking_info = 'Durch die Erstellung eines Sub-Partner-Links haben Sie die M�glichkeit, den Partner-Link zur Verwendung an Ihre Partner weiterzugeben. Sie wissen, wer eine Kommission f�r Sie erbracht hat, da wir Ihnen berichten, welcher Ihrer Sub-Partner den Verkauf vorgenommen hat. Ein weiterer Grund, einen Sub-Partner-Link zu verwenden ist das Vorhandensein eines eigenen Verfolgungssystems, das Sie in die Berichterstattung miteinbeziehen m�chten.',
    sub_tracking_build = 'Ersetzen Sie XXX mit der Partnernummer Ihres Partnerprogramms. Wiederholen Sie diesen Vorgang f�r alle Ihre Partner.',sub_tracking_example = 'Beispiel',sub_tracking_tutorial = 'Anleitung ansehen',sub_tracking_id = 'Sub-Partnernummer',alternate_title = 'Einlaufende Seiten-Links abwechseln',alternate_option_1 = 'Option 1: automatisierte Link-Erstellung',alternate_heading_1 = 'Automatisierte Link-Erstellung',alternate_info_1 = 'Legen Sie Ihre eigene einlaufende Verkehrsseite durch Eingabe des URLs fest, an den Sie den Verkehr weiterleiten m�chten und wir erstellen den Link f�r Sie. Durch die Benutzung der Link k�rzer, den Sie mit dem im Link eingebetteten URL durch eine Nummer in unserer Datenbank verwenden m�ssen.',alternate_button = 'Meinen Link erstellen',alternate_links_heading = 'Meine periodisch einlaufenden URL Links',alternate_links_note = 'Bestehende Links bleiben intakt und funktionell, wenn Sie einen kundenspezifischen Link von dieser Seite entfernen.',alternate_links_remove = 'Entfernen',alternate_option_2 = 'Option 2: Manuelle Link-Erstellung',alternate_info_2 = 'Falls Sie es bevorzugen, Ihre eigenen Partner-Links mit einem periodisch einlaufenden URL zu verbinden, verwenden Sie dazu die folgende Struktur.',alternate_variable = 'Periodisch einlaufende URL-Variable',alternate_example = 'Beispiel',alternate_build = 'Um Ihren Link zu erstellen, nehmen Sie den folgenden URL und verbinden Sie ihn mit dem von Ihnen gew�nschten periodisch einlaufenden URL.',alternate_none = 'Keine periodisch einlaufenden Links erstellt',alternate_tutorial = 'Anleitung ansehen',cr_title = 'Bericht �ber kundenspezifisches Schl�sselwort',cr_select = 'Schl�sselwort ausw�hlen',cr_button = 'Report erstellen',cr_no_results = 'Keine Suchergebnisse gefunden',cr_no_results_info = 'Versuchen Sie eine andere Schl�sselwortkombination',cr_used = 'Verwendete Schl�sselw�rter',cr_found = 'Dieser Link gefunden',cr_times = 'Male',cr_unique = 'Gefundene einmalige Links',cr_detailed = 'Detailierte Link-Bericht',cr_export = 'Bericht an Excel exportieren',cr_none = 'Keine Schl�sselw�rter gefunden',logo_title = 'Laden Sie Ihr Firmenlogo hoch',logo_info = 'Falls Sie Ihr Firmenlogo hochladen m�chten, ist es von Kunden, die Ihre Webseite besuchen, sichtbar. Dadurch wird das Erlebnis der Kunden pers�nlicher gestaltet.',logo_bullet_one = 'Bilder k�nnen im .jpg, .gif oder .png Format sein. Flash-Inhalt ist nicht erlaubt.',logo_bullet_two = 'Fotos werden verworfen und Ihr Konto gesperrt.',logo_bullet_three = 'Ihr Bild/Logo ist erst nach unserer Genehmigung auf unserer Webseite zu sehen.',logo_bullet_size_one = 'Bilder k�nnen maximal Pixel breit sein',logo_bullet_size_two = 'und maximal hoch sein',logo_bullet_req_size_one = 'Bilder m�ssen mindestens Pixel breit sein',logo_bullet_req_size_two = 'und Pixel',logo_bullet_pixels = 'hoch sein.',logo_choose = 'Bild ausw�hlen',logo_file = 'Datei ausw�hlen:',logo_browse = 'Suchen�',logo_button = 'Hochladen',logo_current = 'Mein aktuelles Bild',logo_remove = 'Entfernen',logo_display_status = 'Bildstatus:',logo_pending = 'Schwebende Freigabe',logo_approved = 'Freigegeben',logo_success = 'Das Bild wurde erfolgreich hochgeladen und wartet nun auf die Freigabe.',signup_security_title = 'Kontopr�fung',signup_security_info = 'Bitte geben Sie den im K�stchen angegebenen Sicherheitscode ein. Dieser Schritt hilft uns, automatische Anmeldungen zu verhindern.',signup_security_code = 'Sicherheitscode',sub_tracking_none = 'Keiner',missing_security_code = 'Falsch oder fehlende Kontopr�fung/Sicherheitscode',alternate_success_title = 'Link erfolgreich erstellt',alternate_success_info = 'Nehmen Sie den untenstehenden Link und beginnen Sie damit, Verkehr an Ihren festgelegten URL zu schicken.',alternate_failed_title = 'Fehler bei der Erstellung des Links',alternate_failed_info = 'Bitte geben Sie einen g�ltigen URL ein.',logo_missing_filename = 'Bitte w�hlen Sie einen Dateinamen.',logo_required_width = 'Die Bildbreite muss mindestens betragen',logo_required_height = 'Die Bildh�he muss mindestens betragen',logo_maximum_width = 'Die Bildbreite kann maximal betragen',logo_maximum_height = 'Die Bildh�he kann maximal betragen',logo_size_maximum = 'Die Bildgr��e kann maximal betragen',logo_bad_filetype = 'Diese Bilderart ist nicht erlaubt. Erlaubte Bilderarten sind .gif, .jpg und .png.',
    logo_upload_error = 'Fehler beim Hochladen des Bildes, bitte setzen Sie sich mit dem Partnermanager in Kontakt.',logo_error_title = 'Fehler beim Hochladen des Bildes',logo_error_bytes = 'Bytes.',excel_title = 'Schl�sselwort-Link-Bericht',excel_tab_report = 'Schl�sselwort-Bericht',excel_tab_logs = 'Verkehrsprotokolle',excel_date = 'Berichtsdatum:',excel_affiliate = 'Partnernummer:',excel_criteria = 'Kriterium f�r Schl�sselwort-Link',excel_link = 'Link-Aufbau',excel_hits = 'Einmalige Zugriffe',excel_comm_stats = 'Kommissionsstatistiken',excel_comm_current = 'Aktuelle Kommissionen',excel_comm_paid = 'Bezahlte Kommissionen',excel_comm_total = 'Gesamte Kommissionen',excel_comm_ratio = 'Umrechnungskurs',excel_earned = 'Verdiente Kommissionen',excel_earned_current = 'Aktuelle Kommissionen',excel_earned_paid = 'Bezahlte Kommissionen',excel_earned_total = 'Gesamte verdiente Kommissionen',excel_earned_tab = 'Klicken Sie aufs Tab Verkehrsprotokolle (unten), um das Verkehrsprotokoll f�r diesen Link zu sehen.',excel_log_title = 'Verkehrsprotokoll f�r Schl�sselw�rter',excel_log_ip = 'IP Adresse',excel_log_refer = 'Verweisender URL',excel_log_date = 'Datum',excel_log_time = 'Uhrzeit',excel_log_target = 'Ziel-URL',etemplates_title = 'E-Mail-Vorlagen',etemplates_view_link = 'Diese E-Mail-Vorlage ansehen',etemplates_name = 'Name der Vorlage'");

    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }

    try {
        $db->query("UPDATE idevaff_language_portuguese SET menu_pdf_marketing = 'Brochuras de Marketing PDF',menu_pdf_training = 'Documentos de Treinamento PDF ',marketing_target_url = 'URL Alvo',marketing_source_code = 'C�digo da Fonte -  Copiar/Colar No Seu Website',marketing_group = 'Grupo de Marketing',peels_title = 'Nome do Page Peel ',peels_view = 'Exibir Este Peel',peels_description = 'Descri��o do Page Peel ',lb_head_title = 'C�digo de CABE�ALHO Obrigat�rio Para Sua HTML ',lb_head_description = 'Para usar um lightbox no seu website, voc� precisa adicionar as seguintes linhas na se��o do cabe�alho da p�gina em que deseja exibir.',lb_head_source_code = 'Cole este c�digo na se��o CABE�ALHO do seu documento da HTML .',lb_head_code_notes = 'Voc� s� precisa colocar este c�digo uma vez, independente de quantos lightboxes voc�  colocar na p�gina.',lb_head_tutorial = 'Exibir Tutorial',lb_body_title = 'Nome do Lightbox ',lb_body_description = 'Descri��o do Lightbox ',lb_body_click = 'Clique na imagem acima para exibir o lightbox.',lb_body_source_code = 'Cole este c�digo na se��o do CORPO do seu documento da HTML onde deseja que a imagem apare�a.',pdf_title = 'PDF',pdf_training = 'Documentos de Treinamento',pdf_marketing = 'Brochuras de Marketing ',pdf_description_1 = 'O Adobe Reader � necess�rio para exibir e imprimir nossos materiais de marketing PDF.',pdf_description_2 = 'Adobe Reader � um download gr�tis do website da Adobe.',pdf_file_name = 'Nome do Arquivo',pdf_file_size = 'Tamanho do Arquivo',pdf_file_description = 'Descri��o',pdf_bytes = 'Bytes',menu_heading_training_materials = 'Materiais de Treinamento',menu_videos = 'Assistir V�deos de Treinamento',menu_custom_manual = 'Links Manuais de Rastreamento Personalizados',menu_page_peels = 'Page Peels',menu_lightboxes = 'Lightboxes',menu_email_templates = 'Modelos de E-mail',menu_heading_custom_links = 'Links de Rastreamento Personalizados',menu_custom_reports = 'Relat�rios',menu_keyword_links = 'Palavras-chave de Links de Rastreamento ',menu_subid_links = 'Links de Rastreamento Sub-afiliados',menu_alteranate_links = 'Links Alternativos de P�ginas Recebidas',menu_heading_additional = 'Ferramentas Adicionais',menu_drop_heading_stats = 'Estat�stica Geral ',menu_drop_heading_commissions = 'Comiss�es',menu_drop_heading_history = 'Hist�rico de Pagamentos',menu_drop_heading_traffic = 'Controle de Tr�fego',menu_drop_heading_account = 'Minha Conta',menu_drop_heading_logo = 'Carregar Meu Logo',menu_drop_heading_faq = 'FAQ',menu_drop_general_stats = 'Estat�sticas Gerais',menu_drop_tier_stats = 'Estat�sticas de N�vel',menu_drop_current = 'Comiss�es Atuais',menu_drop_tier = 'Comiss�es de N�vel Atuais',menu_drop_pending = 'Aprova��o Pendente',menu_drop_paid = 'Aprova��o Paga',menu_drop_paid_rec = 'Comiss�es de N�vel Pagas',menu_drop_recurring = 'Comiss�es Ativas Recorrentes',menu_drop_edit = 'Editar Minha Conta',menu_drop_password = 'Mudar Minha Senha',menu_drop_change = 'Mudar Meu Estilo de Comiss�o',account_hidden = 'oculto',keyword_title = 'Links Presonalizados de Palavras-Chave',keyword_info = 'Criar um link personalizado de palavras-chave oferece a possibilidade de rastrear o tr�fego recebido para diversas fontes.  Crie um link com at� 4 palavras-chave de rastreamento e o relat�rio de rastreamento personalizado ir� mostrar um relat�rio detalhado para cada palavra-chave que voc� criar.',keyword_heading = 'Vari�veis Dispon�veis Para Rastreamento Personalizado de Palavras-chave',keyword_tracking = 'ID de Rastreamento',keyword_build = 'Para construir seu link, pegue a seguinte URL e anexe-a com a ID de Rastreamento e a palavra-chave que deseja usar.',keyword_example = 'Exemplo',keyword_tutorial = 'Exibir o Tutorial',sub_tracking_title = 'Rastreamento Sub-afiliado',sub_tracking_info = 'Criar um link sub-afiliado oferece a possibilidade de passar seu link afiliado para fora, para seus pr�piios afiliados possam us�-lo. Voc� saber� quem gerou a comiss�o para voc� porque n�s iremos relatar para voc� qual de seus sub-afiliados gerou a venda. Uma outra raz�o para usar um link sub-afiliado � ter seu pr�prio sistema de rastreamento que deseja inclu�do para o relat�rio.',sub_tracking_build = 'Substitua o XXX com o n�mero de ID do afiliado no seu programa de afiliados.  Repita este processo para todos os seus afiliados.',sub_tracking_example = 'Exemplo',
    sub_tracking_tutorial = 'Exibir Tutorial',sub_tracking_id = 'Rastreamento Sub-afiliado',alternate_title = 'Links Alternativos de P�ginas Recebidas',alternate_option_1 = 'Op��o 1: Cria��o Automatizada de Link',alternate_heading_1 = 'Cria��o Automatizada de Link',alternate_info_1 = 'Definir sua  pr�pria p�gina de tr�fego recebido digitando a URL para qual deseja entregar o tr�fego e n�s Criaremos um link para voc�. Usar este recurso ir� criar um link menor para voc� usar com a URL embutida no link usando o n�mero de ID no seu banco de dados.',alternate_button = 'Criar Meu Link',alternate_links_heading = 'Meus Links Alternativos da URL de Entrada',alternate_links_note = 'Os links existentes permanecer�o intactos e funcionais se voc� remover um link personalizado desta p�gina.',alternate_links_remove = 'remover',alternate_option_2 = 'Op��o 2: Cria��o Manual de Link ',alternate_info_2 = 'Se voc� preferir anexar seus pr�prios links de afiliados com uma URL de entrada alternativa, use a seguinte estrutura.',alternate_variable = 'Vari�vel Alternativa de URL de Entrada',alternate_example = 'Exemplo',alternate_build = 'Para construir seu link, pegue a seguinte URL e anexe-a com a URL de Entrada Alternativa que deseja usar.',alternate_none = 'Nenhum Link de Entrada Alternativo Criado',alternate_tutorial = 'Exibir Tutorial',cr_title = 'Relat�rio de Palavras-chave Personalizado',cr_select = 'Selecione uma Palavra-chave',cr_button = 'Gerar Relat�rio',cr_no_results = 'N�o H� Resultados da Pesquisa',cr_no_results_info = 'Tente uma combina��o diferente de Palavras-chave',cr_used = 'Palavras-chave Usadas',cr_found = 'Este Link Encontrou',cr_times = 'Vezes',cr_unique = 'Links Exclusivos Encontrados',cr_detailed = 'Relat�rio de Link Detalhado',cr_export = 'Exportar Relat�rio Para o Excel',cr_none = 'Nenhuma Palavra-chave Encontrada',logo_title = 'Carregar o Logo da Sua Empresa',logo_info = 'Se voc� quiser carregar o logo de sua Empresa, n�s iremos exibi-lo para os clientes que voc� mandar para o nosso website.  Isto nos permite personalizar sua experi�ncia com o cliente quando ele nos visitar.',logo_bullet_one = 'Imagens podem ser .jpg, .gif or .png.  Nenhum conte�do flash � permitido.',logo_bullet_two = 'Qualquer imagem inapropriada ser� descartada e sua conta suspensa.',logo_bullet_three = 'Sua imagem/logo n�o ser� exibida em nosso website at� ser aprovada.',logo_bullet_size_one = 'As imagens podem ter uma largura m�x de',logo_bullet_size_two = 'pixels e uma altura m�x de ',logo_bullet_req_size_one = 'Imagens devem ter uma largura de',logo_bullet_req_size_two = 'pixels e uma altura de ',logo_bullet_pixels = 'pixels.',logo_choose = 'Escolher Uma Imagem',logo_file = 'Selecionar Um Arquivo:',logo_browse = 'Procurar...',logo_button = 'Carregar',logo_current = 'Minha imagem Atual',logo_remove = 'remover',logo_display_status = 'Status da Imagem:',logo_pending = 'Aprova��o Pendente',logo_approved = 'Aprovado',logo_success = 'Imagem foi carregada com sucesso e est� pendente de aprova��o.',signup_security_title = 'Verifica��o de Conta',signup_security_info = 'Favor digitar o c�digo de seguran�a mostrado no box.  Isto nos ajuda e evitar entradas automatizadas.',signup_security_code = 'C�digo de Seguran�a',sub_tracking_none = 'Nenhum',missing_security_code = 'C�digo de Seguran�a /Verifica��o de Conta Faltando ou Incorreto',alternate_success_title = 'Sucesso Cria��o de Link ',alternate_success_info = 'Pegue seu link abaixo e comece a entregar tr�fego para sua URL definida.',alternate_failed_title = 'Erro ao Criar Link ',alternate_failed_info = 'Favor digitar uma URL v�lida',logo_missing_filename = 'Favor escolher um nome de arquivo.',logo_required_width = 'Largura da imagem deve ser',logo_required_height = 'Altura da imagem deve ser',logo_maximum_width = 'Largura da imagem s� pode ser',logo_maximum_height = 'Altura da imagem s� pode ser',logo_size_maximum = 'Tamanho da imagem s� pode ser um m�x de ',logo_bad_filetype = 'Tipo de imagem n�o � permitido. Tipos permitidos de imagem s�o .jpeg .gif e .png',logo_upload_error = 'Erro ao carregar imagem, favor contactar o gerente afiliado.',logo_error_title = 'Erro ao Carregar Imagem',logo_error_bytes = 'bytes.',excel_title = 'Relat�rio de Links de Palavras-chave Personalizado',excel_tab_report = 'Relat�rio de Palavras-chave Personalizado',excel_tab_logs = 'Controle de Tr�fego',excel_date = 'Data do Relat�rio:',
    excel_affiliate = 'ID de Filiado:',excel_criteria = 'Crit�rio de Link de Palavra-chave',excel_link = 'Estrutura de Link ',excel_hits = 'Hits Exclusivos',excel_comm_stats = 'Estat�sticas de Comiss�es',excel_comm_current = 'Comiss�es Atuais',excel_comm_paid = 'Comiss�es Pagas',excel_comm_total = 'Total das Comiss�es',excel_comm_ratio = 'Taxa de Convers�o',excel_earned = 'Comiss�es Ganhas',excel_earned_current = 'Comiss�es Atuais',excel_earned_paid = 'Comiss�es Pagas',excel_earned_total = 'Total de Comiss�es Ganhas',excel_earned_tab = 'Clique na guia de Controle de Tr�fego (abaixo) para exibir o controle de tr�fego para este link personalizado.',excel_log_title = 'Controle Personalizado de Tr�fego de Palavra-Chave',excel_log_ip = 'Endere�o de IP ',excel_log_refer = 'URL Refer�ncia',excel_log_date = 'Data',excel_log_time = 'Hora',excel_log_target = 'URL Alvo',etemplates_title = 'Modelos de E-mail',etemplates_view_link = 'Exibir Este Modelo de E-mail',etemplates_name = 'Nome do Modelo'");

    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }

    try {
        $db->query("UPDATE idevaff_language_french SET menu_pdf_marketing = 'Brochures marketing PDF',menu_pdf_training = 'Documents formation PDF',marketing_target_url = 'URL Cible',marketing_source_code = 'Code Source � Copiez / Collez dans votre site Web',marketing_group = 'Groupe marketing',peels_title = 'Nom Page Peel',peels_view = 'Voir ce Peel',peels_description = 'Description Page Peel',lb_head_title = 'Code HEAD n�cessaire pour votre page',lb_head_description = 'Si vous voulez utiliser une lightbox dans votre site, vous devez ajouter les lignes suivantes � la section HEAD de la page sur laquelle vous voulez l�afficher.',lb_head_source_code = 'Collez ce code dans la section HEAD de votre document  HTML.',lb_head_code_notes = 'Vous ne devez coller ce code qu�une seule fois, quel que soit le nombre de lightboxes que vous souhaitez placer sur votre page.',lb_head_tutorial = 'Voir tutoriel',lb_body_title = 'Nom de la lightbox',lb_body_description = 'Description de la lightbox',lb_body_click = 'Cliquez sur l�image ci-dessus pour voir la lightbox',lb_body_source_code = 'Collez ce code dans la section BODY de votre document HTML, � l�emplacement o� vous souhaitez faire apparaitre l�image.',pdf_title = 'PDF',pdf_training = 'Documents  formation',pdf_marketing = 'Brochures marketing',pdf_description_1 = 'Vous devez avoir install� Adobe Reader pour visualiser et imprimer nos documents marketing PDF',pdf_description_2 = 'T�l�chargez gratuitement Adobe Reader depuis le site internet d�Adobe.',pdf_file_name = 'Nom du fichier',pdf_file_size = 'Taille du fichier',pdf_file_description = 'Description',pdf_bytes = 'Bytes',menu_heading_training_materials = 'Documents formation',menu_videos = 'Regardez les vid�os de formation',menu_custom_manual = 'Liens formation personnalis�s',menu_page_peels = 'Page Peels',menu_lightboxes = 'Lightboxes',menu_email_templates = 'Mod�les email',menu_heading_custom_links = 'Liens de tra�age personnalis�s',menu_custom_reports = 'Rapports',menu_keyword_links = 'Liens de tra�age par mots-cl�s',menu_subid_links = 'Liens de tra�age par sous-affili�s',menu_alteranate_links = 'Liens de page d�entr�e alternatives',menu_heading_additional = 'Outils additionnels',menu_drop_heading_stats = 'Statistiques g�n�rales',menu_drop_heading_commissions = 'Commissions',menu_drop_heading_history = 'Historique des paiements',menu_drop_heading_traffic = 'Log trafic',menu_drop_heading_account = 'Mon compte',menu_drop_heading_logo = 'T�l�chargement de mon logo',menu_drop_heading_faq = 'FAQ',menu_drop_general_stats = 'Statistiques g�n�rales',menu_drop_tier_stats = 'Statistiques Niveaux',menu_drop_current = 'Commissions actuelles',menu_drop_tier = 'Commissions actuelles niveaux',menu_drop_pending = 'Approbation en attente',menu_drop_paid = 'Approbation pay�e',menu_drop_paid_rec = 'Commissions niveaux pay�es',menu_drop_recurring = 'Commissions r�currentes actives',menu_drop_edit = 'Edition de mon  compte',menu_drop_password = 'Changer mon mot de passe',menu_drop_change = 'Changer mon type de commission',account_hidden = 'Cach�',keyword_title = 'Liens mots-cl�s personnalis�s',keyword_info = 'La cr�ation d�un lien mots-cl�s personnalis�  vous offre la possibilit� de suivre le trafic en provenance de plusieurs sources. Cr�er un lien avec jusqu�� 4 mots-cl�s de tra�age diff�rents ainsi qu�un rapport de tra�age personnalis� vous permettra de consulter un rapport d�taill� pour chaque mot-cl� que vous cr�ez.',keyword_heading = 'Variables disponibles pour le tra�age par mot-cl� personnalis�',keyword_tracking = 'Identification tra�age',keyword_build = 'Pour cr�er votre lien, utilisez l�URL suivante et ajoutez-la � l�identification de tra�age et au mot-cl� que vous souhaitez utiliser.',keyword_example = 'Exemple',keyword_tutorial = 'Voir le tutoriel',sub_tracking_title = 'Tra�age sous-affili�',sub_tracking_info = 'Cr�er un lien sous-affili� vous permet de transmettre votre lien affili� � vos propres affili�s. Vous saurez ainsi qui a g�n�r� votre commission puisque vous aurez acc�s au rapport des ventes g�n�r�es par vos sous-affili�s. Une autre raison qui rend l�utilisation d�un lien de sous-affiliation utile est que vous disposez de votre propre syst�me de tra�age, que vous pouvez vouloir inclure dans les rapports.',
    sub_tracking_build = 'Remplacez XXX avec le num�ro d�identification de votre affili� dans votre programme d�affiliation. R�p�tez ce processus pour tous vos affili�s.',sub_tracking_example = 'Exemple',sub_tracking_tutorial = 'Voir tutoriel',sub_tracking_id = 'Num�ro d�identification sous-affili�',alternate_title = 'Page de liens d�entr�e alternative',alternate_option_1 = 'Option 1 : cr�ation de liens automatis�e',alternate_heading_1 = 'Cr�ation de liens automatis�e',alternate_info_1 = 'D�finissez vous-m�me votre propre trafic entrant en saisissant l�URL aupr�s de laquelle vous souhaitez voir le trafic d�livr� et nous cr�erons un lien pour vous. Avec cette option, vous cr�ez un lien plus court que vous utiliserez avec l�URL embarqu�e dans le lien � l�aide d�un num�ro d�identification pr�sent dans notre base de donn�es.',alternate_button = 'Cr�er mon lien',alternate_links_heading = 'Mes URL d�entr�e alternative',alternate_links_note = 'Les liens existant resteront fonctionnels si vous retir�s un lien personnalis� de cette page.',alternate_links_remove = 'enlever',alternate_option_2 = 'Option 2: Cr�ation manuelle de liens',alternate_info_2 = 'Si vous pr�f�rez ajouter vos propres liens affili�s avec une URL d�entr�e alternative, utilisez la structure suivante',alternate_variable = 'Variable d�URL d�entr�e alternative',alternate_example = 'Exemple',alternate_build = 'Pour cr�er votre lien, utilisez l�URL suivante et ajoutez-la � l�URL d�entr�e alternative que vous voulez utiliser.',alternate_none = 'Aucun lien d�ent�e alternative cr��',alternate_tutorial = 'Voir le tutoriel',cr_title = 'Rapport mot-cl� personnalis�',cr_select = 'Choisir un mot-cl�',cr_button = 'G�n�rer un rapport',cr_no_results = 'Aucun r�sultat trouv�',cr_no_results_info = 'Essayez une autre combinaison de mots-cl�s',cr_used = 'Mots-cl�s utilis�s',cr_found = 'Lien trouv�',cr_times = 'Dur�es',cr_unique = 'Liens uniques trouv�s',cr_detailed = 'Rapport d�taill�',cr_export = 'Exporter le rapport sous Excel',cr_none = 'Aucun mot-cl� trouv�',logo_title = 'T�l�chargez le logo de votre soci�t�',logo_info = 'Si vous d�cidez de t�l�charger le logo de votre soci�t�, nous afficherons ce dernier aupr�s des clients que vous envoyez sur notre site. Cette option nous permet de proposer aux clients qui viennent sur notre site un service personnalis�.',logo_bullet_one = 'Les images peuvent �tre au format .jpg, .gif ou .png.  Le contenu flash n�est pas permis.',logo_bullet_two = 'Toute image inappropri�e sera supprim�e et votre compte sera suspendu.',logo_bullet_three = 'image / logo n�apparaitra sur notre site qu�apr�s avoir �t� approuv�.',logo_bullet_size_one = 'La largeur maximale des images doit �tre de',logo_bullet_size_two = 'pixels et la hauteur maximale de',logo_bullet_req_size_one = 'Les images doivent avoir une largeur de',logo_bullet_req_size_two = 'pixels et une hauteur de',logo_bullet_pixels = 'pixels.',logo_choose = 'Choisir une image',logo_file = 'S�lectionner un fichier :',logo_browse = 'Parcourir...',logo_button = 'Envoyer',logo_current = 'Mes images actuelles',logo_remove = 'Supprimer',logo_display_status = 'Statut de l�image :',logo_pending = 'En attente d�approbation',logo_approved = 'Approuv�',logo_success = 'L�image a bien �t� envoy�e et est maintenant en attente d�approbation',signup_security_title = 'V�rification de compte',signup_security_info = 'Veuillez saisir le code de s�curit� affich� dans la case. Cette �tape nous permet d�emp�cher les connexions automatiques.',signup_security_code = 'Code de s�curit�',sub_tracking_none = 'Aucun',missing_security_code = 'V�rification de compte / code de s�curit� incorrect ou manquant',alternate_success_title = 'Cr�ation de lien r�ussie',alternate_success_info = 'Utilisez le lien ci-dessous et commencez �� envoyer du trafic aupr�s des URL d�finies',alternate_failed_title = 'Erreur de cr�ation de lien',alternate_failed_info = 'Veuillez saisir une URL valide',logo_missing_filename = 'Veuillez choisir un nom de fichier',logo_required_width = 'La largeur des images doit �tre de',logo_required_height = 'La hauteur des images doit �tre de',logo_maximum_width = 'La largeur de l�image ne peut �tre que de',logo_maximum_height = 'La hauteur de l�image ne peut �tre que de',logo_size_maximum = 'La taille de l�image ne doit pas d�passer',
    logo_bad_filetype = 'Ce format d�image n�est pas autoris�. Les formats autoris�s sont gif, .jpg et .png.',logo_upload_error = ' Echec de l�envoi. Veuillez contacter le responsable d�affiliation',logo_error_title = 'Erreur envoi de l�image',logo_error_bytes = 'bytes.',excel_title = 'Rapport personnalis� liens et mots-cl�s',excel_tab_report = 'Rapport mots-cl�s personnalis�s',excel_tab_logs = 'Logs trafic',excel_date = 'Date du rapport :',excel_affiliate = 'Num�ro d�identification affili� :',excel_criteria = 'Crit�res lien / mot-cl�',excel_link = 'Structure du lien',excel_hits = 'Hits uniques',excel_comm_stats = 'Statistiques de commissions',excel_comm_current = 'Commissions actuelles',excel_comm_paid = 'Commissions pay�es',excel_comm_total = 'Total commissions',excel_comm_ratio = 'Ration de conversion',excel_earned = 'Commissions touch�es',excel_earned_current = 'Commissions actuelles',excel_earned_paid = 'Commissions pay�es',excel_earned_total = 'Total des commissions gagn�es',excel_earned_tab = 'Veuillez cliquer sur l�onglet de Log Trafic (ci-dessous) pour consulter le log li� � ce lien personnalis�.',excel_log_title = 'Log trafic mots-cl�s personnalis�s.',excel_log_ip = 'Adresse IP',excel_log_refer = 'URL de r�f�rence',excel_log_date = 'Date',excel_log_time = 'Heure',excel_log_target = 'URL cible',etemplates_title = 'Mod�les email',etemplates_view_link = 'Voir ce mod�le email',etemplates_name = 'Nom du mod�le'");

    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }

    try {
        $db->query("UPDATE idevaff_language_spanish SET menu_pdf_marketing = 'Folletos de Mercadotecnia en PDF',menu_pdf_training = 'Documentos de Entrenamiento en PDF',marketing_target_url = 'URL objetivo',marketing_source_code = 'C�digo fuente - Copiar/Pegar en Su Sitio Web',marketing_group = 'Grupo de Mercadotecnia',peels_title = 'Nombre de Pasa P�ginas',peels_view = 'Ver Este Pasa P�ginas',peels_description = 'Descripci�n de Pasa P�ginas',lb_head_title = 'C�digo de ENCABEZADO requerido Para Su P�gina HTML',lb_head_description = 'Para poder usar una caja de luz en su sitio Web, debe de agregar las siguientes l�neas en la secci�n de encabezado de la p�gina donde quiere mostrarla.',lb_head_source_code = 'Pegue este c�digo en la secci�n de ENCABEZADO de su documento HTML.',lb_head_code_notes = 'S�lo necesita colocar este c�digo una vez sin importar cuantas cajas de luz coloque en la p�gina.',lb_head_tutorial = 'Ver Tutorial',lb_body_title = 'Nombre de Caja de Luz',lb_body_description = 'Descripci�n de Caja de Luz',lb_body_click = 'De clic en la imagen anterior para ver la caja de luz.',lb_body_source_code = 'Pegue este c�digo en la secci�n del CUERPO de su documento HTML donde quiere que aparezca la imagen.',pdf_title = 'PDF',pdf_training = 'Documentos de Entrenamiento',pdf_marketing = 'Folletos de Mercadotecnia',pdf_description_1 = 'Se requiere del Abode Reader para ver e imprimir nuestro material de mercadotecnia en PDF.',pdf_description_2 = 'Se puede descargar gratuitamente el Adobe Reader del sitio Web de Adobe.',pdf_file_name = 'Nombre de Archivo',pdf_file_size = 'Tama�o de Archivo',pdf_file_description = 'Descripci�n',pdf_bytes = 'Bytes',menu_heading_training_materials = 'Material de Entrenamiento',menu_videos = 'Ver Videos de Entrenamiento',menu_custom_manual = 'Manual de Ligas de Rastreo Personalizadas ',menu_page_peels = 'Pasa P�ginas',menu_lightboxes = 'Cajas de Luz',menu_email_templates = 'Plantillas para E-mail',menu_heading_custom_links = 'Ligas de Rastreo Personalizadas',menu_custom_reports = 'Reportes',menu_keyword_links = 'Ligas de Rastreo de Palabra Clave',menu_subid_links = 'Ligas de Rastreo de Sub-Afiliados',menu_alteranate_links = 'Ligas de P�gina de Entradas Alternas',menu_heading_additional = 'Herramientas Adicionales',menu_drop_heading_stats = 'Estad�sticas Generales',menu_drop_heading_commissions = 'Comisiones',menu_drop_heading_history = 'Historial de Pagos',menu_drop_heading_traffic = 'Registro de Tr�fico',menu_drop_heading_account = 'Mi Cuenta',menu_drop_heading_logo = 'Cargar Mi Logotipo',menu_drop_heading_faq = 'Preguntas Frecuentes',menu_drop_general_stats = 'Estad�sticas Generales',menu_drop_tier_stats = 'Estad�sticas de Nivel',menu_drop_current = 'Comisiones Actuales',menu_drop_tier = 'Comisiones de Nivel Actuales',menu_drop_pending = 'Pendientes de Aprobaci�n',menu_drop_paid = 'Aprobaci�n Pagada',menu_drop_paid_rec = 'Comisiones de Nivel Pagadas',menu_drop_recurring = 'Comisiones Activas Recurrentes',menu_drop_edit = 'Editar Mi Cuenta',menu_drop_password = 'Cambiar Mi Contrase�a',menu_drop_change = 'Cambiar Mi Estilo de Comisi�n',account_hidden = 'oculto',keyword_title = 'Ligas de Palabra Clave Personalizadas',keyword_info = 'Creando una liga de palabra clave personalizada le da la capacidad de registrar el tr�fico entrante de diferentes fuentes. Cree una liga con hasta 4 palabras clave de rastreo diferentes y el reporte de rastreo personalizado le mostrar� un reporte detallado por cada palabra clave que cree.',keyword_heading = 'Variables Disponibles Para Rastreo de Palabra Clave Personalizada',keyword_tracking = 'Identidad de Rastreo',keyword_build = 'Para construir su liga, tome el URL siguiente y agr�guela con la Identidad de Rastreo y la palabra clave que quiere usar. ',keyword_example = 'Ejemplo',keyword_tutorial = 'Ver el Tutorial',sub_tracking_title = 'Rastreo de Sub-Afiliado',sub_tracking_info = 'El crear una liga de sub-afiliado le da la capacidad de pasar su liga de afiliado a sus propios afiliados para que la usen. Sabr� quien gener� la comisi�n para usted porque le reportaremos cu�l de sus sub-afiliados gener� la venta. Otra raz�n para usar un enlace de sub-afiliado es si tiene su propio sistema de rastreo que quiere incluir para reportes. ',
    sub_tracking_build = 'Reemplace la XXX con el n�mero de identidad del afiliado en su programa de afiliados. Repita este proceso para todos sus afiliados.',sub_tracking_example = 'Ejemplo',sub_tracking_tutorial = 'Ver Tutorial',sub_tracking_id = 'Identidad de Sub-Afiliado',alternate_title = 'Ligas de P�gina de Entradas Alternas',alternate_option_1 = 'Opci�n 1: Creaci�n Automatizada de Liga',alternate_heading_1 = 'Creaci�n Automatizada de Liga',alternate_info_1 = 'Defina su p�gina de tr�fico de entrada ingresando el URL de donde quiere recibir el tr�fico y crearemos una liga para usted. Usando esta caracter�stica crear� una liga m�s corta para que usted la use con el URL insertado en la liga usando el n�mero de identidad en nuestra base de datos. ',alternate_button = 'Crear Mi Liga',alternate_links_heading = 'Mis Ligas de URL de Entradas Alternas',alternate_links_note = 'Las ligas existentes permanecer�n intactas y funcionales si remueve una liga personalizada de esta p�gina.',alternate_links_remove = 'remover',alternate_option_2 = 'Opci�n 2: Creaci�n Manual de Liga',alternate_info_2 = 'Si prefiere agregar sus propias ligas de afiliado con un URL de entrada alterno, use la siguiente estructura.',alternate_variable = 'Variable de URL de Entrada Alterno',alternate_example = 'Ejemplo',alternate_build = 'Para construir su liga, tome el URL siguiente y agr�guela con la Identidad de Rastreo y la palabra clave que quiere usar. ',alternate_none = 'No se Crearon Ligas de Entrada Alternas',alternate_tutorial = 'Ver Tutorial',cr_title = 'Reporte de Palabras Claves Personalizadas',cr_select = 'Seleccione Una Palabra Clave',cr_button = 'Generar Reporte',cr_no_results = 'No Se Encontraron Resultados de B�squeda',cr_no_results_info = 'Intente una Combinaci�n de Palabra Clave Diferente',cr_used = 'Palabras Clave Usadas',cr_found = 'Se Encontr� Esta Liga',cr_times = 'Veces',cr_unique = 'Ligas �nicas Encontradas',cr_detailed = 'Reporte Detallado de Liga',cr_export = 'Exportar Reporte A Excel',cr_none = 'No Se Encontraron Palabras Claves',logo_title = 'Cargar El Logotipo de Su Compa��a',logo_info = 'Si desea cargar el logotipo de su Compa��a, la mostraremos a los clientes que lleve a nuestro sitio Web. Esto nos permite personalizar la experiencia de su cliente cuando nos visita.',logo_bullet_one = 'Las im�genes pueden ser .jpg, .gif, o .png. No se permite contenido flash.',logo_bullet_two = 'Cualquier imagen inapropiada ser� desechada y su cuenta ser� suspendida.',logo_bullet_three = 'Si imagen/logo no ser� mostrada en nuestro sitio Web hasta que la hayamos aprobado.',logo_bullet_size_one = 'Las im�genes pueden tener un ancho m�ximo de ',logo_bullet_size_two = 'p�xeles y una altura m�xima de ',logo_bullet_req_size_one = 'Las im�genes deben de tener un ancho de',logo_bullet_req_size_two = 'p�xeles y una altura de',logo_bullet_pixels = 'p�xeles.',logo_choose = 'Escoja Una Imagen',logo_file = 'Seleccione Un Archivo:',logo_browse = 'Navegar�',logo_button = 'Cargar',logo_current = 'Mi Imagen Actual',logo_remove = 'remover',logo_display_status = 'Estado de Imagen:',logo_pending = 'Pendiente de Aprobaci�n',logo_approved = 'Aprobada',logo_success = 'La imagen fue cargada exitosamente y ahora est� pendiente de aprobaci�n.',signup_security_title = 'Verificaci�n de Cuenta',signup_security_info = 'Por favor ingrese el c�digo de seguridad mostrado en el recuadro. Este paso nos ayuda a prevenir registros automatizados.',signup_security_code = 'C�digo de Seguridad',sub_tracking_none = 'Ninguno',missing_security_code = 'C�digo de Verificaci�n / Seguridad de Cuenta Incorrecto o Faltante',alternate_success_title = '�xito en Creaci�n de Liga',alternate_success_info = 'Tome su liga a continuaci�n y comience a llevar tr�fico a su URL definido.',alternate_failed_title = 'Error en Creaci�n de Liga',alternate_failed_info = 'Por favor ingrese un URL v�lido.',logo_missing_filename = 'Por favor escoja un nombre de archivo.',logo_required_width = 'El ancho de imagen debe ser',logo_required_height = 'La altura de la imagen debe ser',logo_maximum_width = 'El ancho de imagen s�lo puede ser',logo_maximum_height = 'La altura de la imagen s�lo puede ser',logo_size_maximum = 'El tama�o de la imagen s�lo puede ser un m�ximo de',
    logo_bad_filetype = 'El tipo de imagen no es permitido. Los tipos de imagen permitidos son .gif, .jpg, y .png.',logo_upload_error = 'Error al cargar imagen, por favor contacte al gerente de afiliaci�n.',logo_error_title = 'Error al cargar imagen',logo_error_bytes = 'bytes.',excel_title = 'Reporte de Ligas de Palabra Clave Personalizadas',excel_tab_report = 'Reporte de Palabras Clave Personalizadas',excel_tab_logs = 'Registros de Tr�fico',excel_date = 'Fecha de Reporte:',excel_affiliate = 'Identidad de Afiliado:',excel_criteria = 'Criterios para Liga de Palabra Clave',excel_link = 'Estructura de Liga',excel_hits = 'Visitas �nicas',excel_comm_stats = 'Estad�sticas de Comisi�n',excel_comm_current = 'Comisiones Actuales',excel_comm_paid = 'Comisiones Pagadas',excel_comm_total = 'Comisiones Totales',excel_comm_ratio = 'Radio de Conversi�n',excel_earned = 'Comisiones Ganadas',excel_earned_current = 'Comisiones Actuales',excel_earned_paid = 'Comisiones Pagadas',excel_earned_total = 'Total de Comisiones Ganadas',excel_earned_tab = 'De clic en la pesta�a de Registros de Tr�fico (a continuaci�n) para ver el registro de tr�fico para esta liga personalizada.',excel_log_title = 'Registro de Tr�fico de Palabras Claves Personalizadas',excel_log_ip = 'Direcci�n de IP',excel_log_refer = 'URL referente',excel_log_date = 'Fecha',excel_log_time = 'Hora',excel_log_target = 'URL objetivo',etemplates_title = 'Plantillas para E-mail',etemplates_view_link = 'Ver Esta Plantilla para E-mail',etemplates_name = 'Nombre de Plantilla'");

    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }

    try {
        $db->query("UPDATE idevaff_language_italian SET menu_pdf_marketing = 'Brochure di marketing in formato PDF ',menu_pdf_training = 'Documenti sulla formazione in formato PDF ',marketing_target_url = 'URL di destinazione',marketing_source_code = 'Codice fonte - Copia/Incolla sul sito web',marketing_group = 'Gruppo marketing ',peels_title = 'Nome pagina peel ',peels_view = 'Visualizza questo peel',peels_description = 'Descrizione pagina peel ',lb_head_title = 'Codice HEAD (testata) necessario per la pagina HTML ',lb_head_description = 'Per utilizzare una casella sul sito web, � necessario aggiungere le linee seguenti alla sezione HEAD (testata) della pagina in cui lo si desidera visualizzato.',lb_head_source_code = 'Incollare questo codice nella sezione HEAD (testata) del documento HTML.',lb_head_code_notes = '� necessario solo mettere questo codice una volta indipendentemente da quante caselle si inseriscono nella pagina.',lb_head_tutorial = 'Visualizza Esercitazioni',lb_body_title = 'Nome casella',lb_body_description = 'Descrizione casella',lb_body_click = 'Fare clic sull ''immagine superiore per visualizzare la casella.',lb_body_source_code = 'Incollare questo codice nella sezione BODY (corpo) del documento HTML  dove si desidera far comparire l ''immagine.',pdf_title = 'PDF',pdf_training = 'Documenti relativi alla formazione',pdf_marketing = 'Brochure sul marketing',pdf_description_1 = 'Adobe Reader � necessario per visualizzare e stampare il nostro materiale di marketing in formato PDF.',pdf_description_2 = 'Adobe Reader � un software gratuito che pu� essere scaricato sul sito web di Adobe.',pdf_file_name = 'Nome file',pdf_file_size = 'Dimensione file',pdf_file_description = 'Descrizione',pdf_bytes = 'Byte',menu_heading_training_materials = 'Materiale per esercitazioni',menu_videos = 'Vedi video per esercitazioni',menu_custom_manual = 'Manuale dei link di controllo personalizzati',menu_page_peels = 'Pagine peel',menu_lightboxes = 'Caselle',menu_email_templates = 'Modelli e-mail',menu_heading_custom_links = 'Link di controllo personalizzati',menu_custom_reports = 'Rapporti',menu_keyword_links = 'Link di controllo per parole chiave',menu_subid_links = 'Link di controllo sotto-affiliati',menu_alteranate_links = 'Alterna link di pagine in entrata',menu_heading_additional = 'Strumenti aggiuntivi',menu_drop_heading_stats = 'Statistiche generali',menu_drop_heading_commissions = 'Commissioni',menu_drop_heading_history = 'Cronologia pagamenti',menu_drop_heading_traffic = 'Registro traffico',menu_drop_heading_account = 'Account',menu_drop_heading_logo = 'Carico il mio Logo',menu_drop_heading_faq = 'FAQ (Domande pi� frequenti)',menu_drop_general_stats = 'Statistiche generali',menu_drop_tier_stats = 'Statistiche livelli',menu_drop_current = 'Commissioni correnti',menu_drop_tier = 'Commissioni correnti dei livelli',menu_drop_pending = 'In attesa di approvazione',menu_drop_paid = 'Approvazione pagata',menu_drop_paid_rec = 'Commissioni dei livelli pagati',menu_drop_recurring = 'Commissioni ricorrenti attive',menu_drop_edit = 'Modifica il mio Account',menu_drop_password = 'Modifica la password',menu_drop_change = 'Modifica lo Stile della mia commissione',account_hidden = 'nascosto',keyword_title = 'Link di parole chiave personalizzati',keyword_info = 'Creando un link di parole chiave personalizzato permette di controllare il traffico in entrata per diverse fonti.  Crea un link con un massimo di 4 parole chiave di controllo diverse e il rapporto di controllo personalizzato mostrer� un rapporto dettagliato per ogni parola chiave creata.',keyword_heading = 'Variabili disponibili per controllo di parole chiave personalizzato',keyword_tracking = 'ID di controllo',keyword_build = 'Per creare il link, prendere l ''URL seguente e apporlo con l ''ID di controllo e parola chiave che si desidera utilizzare.',keyword_example = 'Esempio',keyword_tutorial = 'Vedi l ''esercitazione',sub_tracking_title = 'Controllo sotto-affiliato',sub_tracking_info = 'La creazione di un link sotto-affiliato permette di passare il link affiliato alle proprie affiliazioni al fine di utilizzarlo. � possibile sapere chi ha generato la commissione poich� vengono riportate quali sotto-affiliazioni hanno generato la vendita. Un altro motivo per utilizzare un link affiliati � se si dispone di un proprio sistema di controllo da includere per il rapporto.',
    sub_tracking_build = 'Sostituire le XXX con il numero ID dell ''affiliazione nel proprio programma di affiliazione.  Ripetere questo processo per tutte le affiliazioni.',sub_tracking_example = 'Esempio',sub_tracking_tutorial = 'Visualizza Esercitazioni',sub_tracking_id = 'ID sotto-affiliazione ',alternate_title = 'Alterna link di pagine in entrata',alternate_option_1 = 'Opzione 1 : Creazione di link automatizzata',alternate_heading_1 = 'Creazione automatizzata di un link ',alternate_info_1 = 'Definire la propria pagina di traffico in entrata inserendo l ''URL al quale si desidera inviare il traffico e ti sar� creato un link. Utilizzando questa funzione si crea un link da utilizzare con l ''URL inserito nel link utilizzando un numero ID nel nostro database.',alternate_button = 'Crea il mio link',alternate_links_heading = 'Link in entrata dell ''URL alternativo',alternate_links_note = 'I link esistenti resteranno intatti e funzionali se viene rimosso da questa pagina un link personalizzato.',alternate_links_remove = 'rimuovi',alternate_option_2 = 'Opzione 2 : Creazione manuale di un link',alternate_info_2 = 'Se si desidera apporre i propri link affiliati con un URL in entrata alternativo, utilizzare la seguente struttura.',alternate_variable = 'Variabile dell ''URL in entrata alternativa',alternate_example = 'Esempio',alternate_build = 'Per creare il link, prendere l ''URL seguente e apporlo con l ''URL in entrata alternativo che si desidera utilizzare.',alternate_none = 'Nessun link in entrata alternativo creato',alternate_tutorial = 'Visualizza Esercitazioni',cr_title = 'Rapporto parole chiave personalizzato',cr_select = 'Selezionare una parola chiave',cr_button = 'Generare rapporto',cr_no_results = 'Nessun risultato della ricerca trovato',cr_no_results_info = 'Prova una diversa combinazione di parole chiave',cr_used = 'Parole chiave utilizzate',cr_found = 'Link trovato',cr_times = 'Tempi',cr_unique = 'Link unici trovati',cr_detailed = 'Rapporto link dettagliato',cr_export = 'Esporta il rapporto in file Excel',cr_none = 'Nessuna parola chiave trovata',logo_title = 'Carica il logo della societ�',logo_info = 'Se si desidera carica il logo della propria societ�, lo visualizzeremo ai clienti che inviata al nostro sito web.  In tal modo potremo personalizzare l ''esperienza dei vostri clienti ogni qualvolta che ci fanno visita.',logo_bullet_one = 'Le immagini possono essere in .jpg, .gif o .png.  Non � permesso alcun contenuto flash.',logo_bullet_two = 'Qualsiasi immagine non appropriata sar� eliminata e l ''account bloccato.',logo_bullet_three = 'L ''immagine/logo non sar� mostrata sul nostro sito web se non viene approvata.',logo_bullet_size_one = 'Le immagini possono avere una larghezza massima di',logo_bullet_size_two = 'pixel e un ''altezza massima di',logo_bullet_req_size_one = 'Le immagini devono avere una larghezza massima di',logo_bullet_req_size_two = 'pixel e un ''altezza di',logo_bullet_pixels = 'pixel.',logo_choose = 'Scegli un ''immagine',logo_file = 'Seleziona un file:',logo_browse = 'Sfoglia...',logo_button = 'Carica',logo_current = 'Immagine corrente',logo_remove = 'rimuovi',logo_display_status = 'Stato dell ''immagine:',logo_pending = 'In attesa di approvazione',logo_approved = 'Approvato',logo_success = 'L ''immagine � stata caricata con successo ed � in attesa di approvazione.',signup_security_title = 'Verifica dell ''account ',signup_security_info = 'Inserire il codice di sicurezza mostrato nella casella.  Questa fase aiuta a prevenire accessi automatizzati.',signup_security_code = 'Codice di sicurezza',sub_tracking_none = 'Nessuno',missing_security_code = 'Verifica dell ''account non corretta o mancante / Codici di sicurezza',alternate_success_title = 'Creazione del link avvenuta con successo',alternate_success_info = 'Prendere il link di seguito e iniziare a fornire traffico all ''URL definito.',alternate_failed_title = 'Errore nella creazione del link',alternate_failed_info = 'Immettere un URL valido.',logo_missing_filename = 'Scegliere un nome file.',logo_required_width = 'La larghezza dell ''immagine deve essere',logo_required_height = 'L ''altezza dell ''immagine deve essere',logo_maximum_width = 'La larghezza dell ''immagine pu� essere solo',logo_maximum_height = 'L ''altezza dell ''immagine pu� essere solo',logo_size_maximum = 'La dimensione dell ''immagine pu� essere solo di massimo',
    logo_bad_filetype = 'Il tipo di immagine non � consentito. Tipi di immagine permessi sono .gif, .jpg e .png.',logo_upload_error = 'Errore nel caricamento dell ''immagine, contattare il direttore affiliato.',logo_error_title = 'Errore nel caricamento dell ''immagine',logo_error_bytes = 'byte.',excel_title = 'Rapporto sui link parole chiave personalizzati',excel_tab_report = 'Rapporto parole chiave personalizzato',excel_tab_logs = 'Registri traffico',excel_date = 'Data rapporto:',excel_affiliate = 'ID affiliazione:',excel_criteria = 'Criteri link parole chiave',excel_link = 'Struttura dei link ',excel_hits = 'Hit unici',excel_comm_stats = 'Statistiche commissioni',excel_comm_current = 'Commissioni correnti',excel_comm_paid = 'Commissioni pagate',excel_comm_total = 'Commissioni totali',excel_comm_ratio = 'Rapporto conversione',excel_earned = 'Commissioni guadagnate',excel_earned_current = 'Commissioni correnti',excel_earned_paid = 'Commissioni pagate',excel_earned_total = 'Commissioni totali guadagnate',excel_earned_tab = 'Fare clic  sulla scheda Registri Traffico (di seguito) per visualizzare il registro traffico per questo link personalizzato.',excel_log_title = 'Registro traffico per parole chiave personalizzate',excel_log_ip = 'Indirizzo IP',excel_log_refer = 'URL di riferimento',excel_log_date = 'Data',excel_log_time = 'Ora',excel_log_target = 'URL di destinazione',etemplates_title = 'Modelli e-mail',etemplates_view_link = 'Visualizza questo modello di e-mail',etemplates_name = 'Nome modello'");

    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }

    try {
        $db->query("UPDATE idevaff_language_dutch SET menu_pdf_marketing = 'PDF marketingbrochures',menu_pdf_training = 'PDF trainingsdocumenten',marketing_target_url = 'Doel URL',marketing_source_code = 'Broncode � In uw website kopi�ren/plakken',marketing_group = 'Marketinggroep',peels_title = 'Page peel naam',peels_view = 'Deze peel bekijken',peels_description = 'Page peel beschrijven',lb_head_title = 'Vereiste HEAD code voor uw HTML pagina',lb_head_description = 'Om een lightbox op uw website te gebuiken dient u de volgende regels aan de head sectie van de pagina die u weer wilt laten geven toe te voegen.',lb_head_source_code = 'Plak deze code in de HEAD sectie van uw HTML document.',lb_head_code_notes = 'U hoeft deze code slechts eenmaal te plaatsen, onafhankelijk van hoeveel lightboxen u op de pagina plaatst.',lb_head_tutorial = 'Tutorial bekijken',lb_body_title = 'Lightbox naam',lb_body_description = 'Lightbox beschrijving',lb_body_click = 'Klik op de bovenstaande afbeelding om de lightbox te bekijken.',lb_body_source_code = 'Plak deze code in de BODY sectie van uw HTML document waar u wilt dat de afbeelding verschijnt.',pdf_title = 'PDF',pdf_training = 'Trainingsdocumenten',pdf_marketing = 'Marketingbrochures',pdf_description_1 = 'Adobe Reader is vereist om ons PDF marketingmateriaal te bekijken en af te drukken.',pdf_description_2 = 'Adobe Reader is een gratis download van de Adobe website.',pdf_file_name = 'Bestandsnaam',pdf_file_size = 'Bestandsgrootte',pdf_file_description = 'Omschrijving',pdf_bytes = 'Bytes',menu_heading_training_materials = 'Trainingmateriaal',menu_videos = 'Trainingsvideo�s bekijken',menu_custom_manual = 'Handleiding Op maat gemaakte tracking links',menu_page_peels = 'Page peels',menu_lightboxes = 'Lightboxen',menu_email_templates = 'E-mail sjablonen',menu_heading_custom_links = 'Op maat gemaakte tracking links',menu_custom_reports = 'Rapporten',menu_keyword_links = 'Tracking links op trefwoord',menu_subid_links = 'Tracking links op subdochteronderneming',menu_alteranate_links = 'Binnenkomende paginalinks afwisselen',menu_heading_additional = 'Extra hulpmiddelen',menu_drop_heading_stats = 'Algemene stats',menu_drop_heading_commissions = 'Commissies',menu_drop_heading_history = 'Betalingshistorie',menu_drop_heading_traffic = 'Verkeerslog',menu_drop_heading_account = 'Mijn account',menu_drop_heading_logo = 'Mijn logo uploaden',menu_drop_heading_faq = 'FAQ',menu_drop_general_stats = 'Algemene statistieken',menu_drop_tier_stats = 'Tier statistieken',menu_drop_current = 'Huidige commissies',menu_drop_tier = 'Huidige tier commissies',menu_drop_pending = 'In afwachting van goedkeuring',menu_drop_paid = 'Betaalde goedkeuring',menu_drop_paid_rec = 'Betaalde tier commissies',menu_drop_recurring = 'Actieve periodieke commissies',menu_drop_edit = 'Mijn account bewerken',menu_drop_password = 'Mijn wachtwoord wijzigen',menu_drop_change = 'Mijn commissiestijl wijzigen',account_hidden = 'verborgen',keyword_title = 'Op maat gemaakte trefwoordlinks',keyword_info = 'Het aanmaken van een op maat gemaakte trefwoordlink biedt u de mogelijkheid binnenkomend verkeer op verscheidene bronnen te controleren.  Maak een link aan met tot maximaal 4 verschillende trefwoorden, waarna het op maat gemaakte tracking rapport u voor elk trefwoord dat u aanmaakt een gedetailleerd rapport toont.',keyword_heading = 'Beschikbare variabelen voor op maat gemaakte tracking op trefwoord',keyword_tracking = 'Tracking ID',keyword_build = 'Om uw link te bouwen, neem de volgende URL en voeg deze toe aan de Tracking ID en het trefwoord dat u wilt gebruiken.',keyword_example = 'Voorbeeld',keyword_tutorial = 'De tutorial bekijken',sub_tracking_title = 'Tracking op subdochteronderneming',sub_tracking_info = 'Het aanmaken van een link voor subdochterondernemingen biedt u de mogelijkheid uw dochterondernemingslink door te geven aan uw eigen dochterondernemingen, zodat deze ze kunnen gebruiken. U weet wie de commissie voor u gegenereerd heeft, omdat wij aan u rapporteren welke van uw subdochterondernemingen de verkoop gegenereerd heeft. Nog een reden om een subdochterondernemingslink te gebruiken is dat als u uw eigen tracking systeem heeft, wilt u dat deze opgenomen wordt in de rapportage.',sub_tracking_build = 'Vervang de XXX door het ID-nummer van de dochteronderneming in uw dochterondernemingsprogramma.  Herhaal dit proces voor al uw dochterondernemingen.',
    sub_tracking_example = 'Voorbeeld',sub_tracking_tutorial = 'Tutorial bekijken',sub_tracking_id = 'Dochteronderneming ID',alternate_title = 'Afwisselend binnenkomende paginalinks',alternate_option_1 = 'Optie 1: Geautomatiseerde aanmaak van links',alternate_heading_1 = 'Geautomatiseerde aanmaak van links',alternate_info_1 = 'Definieer uw binnenkomende verkeerspagina door de URL in te voeren waarheen u verkeer naar afgeleverd will hebben, waarna wij een link voor u zullen aanmaken. Door gebruik te maken van dit onderdeel wordt er een kortere link voor u aangemaakt om te gebruiken met de URL ingebed in de link met behulp van een ID-nummer in onze database.',alternate_button = 'Mijn link aanmaken',alternate_links_heading = 'Mijn afwisselend binnenkomende URL links',alternate_links_note = 'Bestaande links blijven intact en functioneel als u een op maat gemaakte link van deze pagina verwijdert.',alternate_links_remove = 'verwijder',alternate_option_2 = 'Optie 2: Manuele aanmaak van links',alternate_info_2 = 'Als u uw eigen dochterondernemingslinks liever toevoegt met een afwisselend binnenkomende URL, gebruik dan de volgende structuur.',alternate_variable = 'Afwisselend binnenkomende URL variabele',alternate_example = 'Voorbeeld',alternate_build = 'Om uw link te bouwen, neem de volgende URL en voeg deze toe aan de afwisselend binnenkomende URL die u wilt gebruiken.',alternate_none = 'Geen afwisselend binnenkomende links aangemaakt',alternate_tutorial = 'Tutorial bekijken',cr_title = 'Op maat gemaakt trefwoordrapport',cr_select = 'Een trefwoord selecteren',cr_button = 'Rapport genereren',cr_no_results = 'Geen zoekresultaten gevonden',cr_no_results_info = 'Probeer een andere trefwoordcombinatie',cr_used = 'Gebruikte trefwoorden',cr_found = 'Deze link gevonden',cr_times = 'Keer',cr_unique = 'Unieke links gevonden',cr_detailed = 'Gedetailleerd linkrapport',cr_export = 'Rapport exporteren naar Excel',cr_none = 'Geen trefwoorden gevonden',logo_title = 'Uw bedrijfslogo uploaden',logo_info = 'Als u uw bedrijfslogo graag wilt uploaden, geven wij dit weer aan klanten die u aan onze website levert.  Dit stelt ons in staat de ervaring van uw klanten te personaliseren wanneer deze ons bezoeken.',logo_bullet_one = 'Afbeeldingen kunnen in .jpg, .gif of .png zijn.  Flashinhoud is niet toegestaan.',logo_bullet_two = 'Ongeschikte afbeeldingen worden verwijderd en uw account opgeschort.',logo_bullet_three = 'Uw afbeelding/logo wordt niet op onze website getoond totdat we deze/dit hebben goedgekeurd.',logo_bullet_size_one = 'Afbeeldingen mogen een maximale breedte hebben van',logo_bullet_size_two = 'pixels en een maximale hoogte van',logo_bullet_req_size_one = 'Afbeeldingen dienen een breedte te hebben van',logo_bullet_req_size_two = 'pixels en een hoogte van',logo_bullet_pixels = 'pixels.',logo_choose = 'Een afbeelding kiezen',logo_file = 'Een bestand selecteren:',logo_browse = 'Browsen...',logo_button = 'Uploaden',logo_current = 'Mijn huidige afbeelding',logo_remove = 'verwijder',logo_display_status = 'Afbeeldingsstatus:',logo_pending = 'In afwachting van goedkeuring',logo_approved = 'Goedgekeurd',logo_success = 'De afbeelding is geupload en is nu in afwachting van goedkeuring.',signup_security_title = 'Account verificatie',signup_security_info = 'Voer de in het vakje getoonde veiligheidscode in.  Deze stap helpt ons automatische aanmeldingen te voorkomen.',signup_security_code = 'Veiligheidscode',sub_tracking_none = 'Geen',missing_security_code = 'Onjuiste of ontbrekende account verificatie / veiligheidscode',alternate_success_title = 'Aanmaak link gelukt',alternate_success_info = 'Grijp uw link hieronder en begin met het afleveren van verkeer naar uw gedefinieerde URL.',alternate_failed_title = 'Fout bij het aanmaken van link',alternate_failed_info = 'Voer een geldige URL in',logo_missing_filename = 'Kies een bestandsnaam.',logo_required_width = 'Breedte afbeelding moet het volgende zijn',logo_required_height = 'Hoogte afbeelding moet het volgende zijn',logo_maximum_width = 'Breedte afbeelding kan slechts het volgende zijn',logo_maximum_height = 'Hoogte afbeelding kan slechts het volgende zijn',logo_size_maximum = 'Grootte afbeelding mag slechts maximaal het volgende zijn',logo_bad_filetype = 'Afbeeldingstype is niet toegestaan. Toegestane afbeeldingstypen zijn .gif, .jpg en .png.',logo_upload_error = 'Fout bij uploaden afbeelding, neem contact op met de manager van de dochteronderneming.',
    logo_error_title = 'Fout bij uploaden afbeelding',logo_error_bytes = 'bytes.',excel_title = 'Op maat gemaakt rapport met trefwoordlinks',excel_tab_report = 'Op maat gemaakt trefwoordrapport',excel_tab_logs = 'Verkeerslogs',excel_date = 'Rapportdatum:',excel_affiliate = 'Dochteronderneming ID:',excel_criteria = 'Trefwoordlinkcriteria',excel_link = 'Linkstructuur',excel_hits = 'Unieke hits',excel_comm_stats = 'Commissiestatistieken',excel_comm_current = 'Actuele commissies',excel_comm_paid = 'Betaalde commissies',excel_comm_total = 'Totale commissies',excel_comm_ratio = 'Conversieverhouding',excel_earned = 'Verdiende commissies',excel_earned_current = 'Actuele commissies',excel_earned_paid = 'Betaalde commissies',excel_earned_total = 'Totale verdiende commissies',excel_earned_tab = 'Klik op het tabblad voor verkeerslogs (hieronder) om het verkeerslog voor deze op maat gemaakte link te bekijken.',excel_log_title = 'Op maat gemaakt verkeerslog met trefwoorden',excel_log_ip = 'IP-adres',excel_log_refer = 'Verwijzings-URL',excel_log_date = 'Datum',excel_log_time = 'Tijd',excel_log_target = 'Doel URL',etemplates_title = 'E-mail sjablonen',etemplates_view_link = 'Dit e-mail sjabloon bekijken',etemplates_name = 'Sjabloonnaam'");

    } catch (Exception $ex) {
        $ret_ajax['errors'][] = $ex->getMessage();
    }
}

// -----------


// CONVERT TEXT ADS
// ---------------------------------------------------------------------
try {
    $db->query('ALTER TABLE `idevaff_ads` ADD COLUMN `converted` INT(64) NOT NULL default \'0\'');
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}


$getdata = $db->query("select * from idevaff_ads");
if ($getdata->rowCount()) {
    while ($qry = $getdata->fetch()) {
        $id = $qry['id'];
        $title = $qry['title'];
        $text = $qry['text'];
        $converted = $qry['converted'];
        if ($converted == 0) {
            try {
                $db_update = $db->prepare("update idevaff_ads set title = ?, text = ?, converted = '1' where id = ?");
                $db_update->execute(array($title,$text,$id));
            } catch (Exception $ex) {
                $ret_ajax['errors'][] = $ex->getMessage();
            }
        }
    }
}

// Retrieve list of archived payments
$result = $db->query('select record, stamp from idevaff_archive where payment_rec=0');

if ( $result->rowCount() ) {
    while($row = $result->fetch() ) {
        // Find the corresponding payment record
        $pay_result = $db->query('select record from idevaff_payments where stamp = ' . $row['stamp']);
        if($pay_result->rowCount()) {
            $pay_row = $pay_result->fetch();
            try {
                $db->query('update idevaff_archive set payment_rec=' . $pay_row['record']
                    . ' where record = ' . $row['record']);
            } catch (Exception $ex) {
                $ret_ajax['errors'][] = $ex->getMessage();
            }
        }
    }
}


$upgrade_version = '6.0';
try {
    $db_update = $db->prepare("update idevaff_config set version = ?");
    $db_update->execute(array($upgrade_version));
} catch (Exception $ex) {
    $ret_ajax['errors'][] = $ex->getMessage();
}


$db->query("delete from idevaff_admin");
?>
