<?php

if(!defined('AFF_KEY')) {
    die();
}

require_once $path . "/includes/integrations/constant_contact/constant_contact/src/Ctct/autoload.php";

use Ctct\Auth\CtctOAuth2;
use Ctct\Exceptions\OAuth2Exception;
use Ctct\ConstantContact;
use Ctct\Components\Contacts\Contact;
use Ctct\Components\Contacts\ContactList;
use Ctct\Components\Contacts\EmailAddress;
use Ctct\Exceptions\CtctException;

class IdevConstantContactUtil {
    private $data;
    private $table;
    private $meta_key;
    public function __construct($data = array()) {
        if(empty($data)) {
            $this->getDataFromDatabase();
        }
        else {
            $this->data = $data;
        }
        $this->table = 'idevaff_newsletter_addons';
        $this->meta_key = 'constant_contact';
    }
 
    public function __toString() {
        return print_r($this->data,true);
    }
    
    public function getLists() {
        $cc = new ConstantContact($this->data['api_key']);
        $lists = array();
        // attempt to fetch lists in the account, catching any exceptions and printing the errors to screen
        try {
            $lists = $cc->getLists($this->data['access_token']);
        } catch (CtctException $ex) {
            foreach ($ex->getErrors() as $error) {
                $lists['error'][] = $error;
            }
        }
        return $lists;
    }
    
    public function addContact($list,$email,$fname,$lname) {
        $cc = new ConstantContact($this->data['api_key']);
        try {
            // check to see if a contact with the email addess already exists in the account
            $response = $cc->getContactByEmail($this->data['access_token'], $email);
            $ret = array();
            if (empty($response->results)) {
                // create a new contact if one does not exist                
                $contact = new Contact();
                $contact->addEmail($email);
                $contact->addList($list);
                $contact->first_name = $fname;
                $contact->last_name = $lname;
                $returnContact = $cc->addContact($this->data['access_token'], $contact, true);
            } else {
                // update the existing contact if address already existed 
                $contact = $response->results[0];
                $contact->addList($list);
                $contact->first_name = $fname;
                $contact->last_name = $lname;
                $returnContact = $cc->updateContact($this->data['access_token'], $contact, true);
            }
        } catch (CtctException $ex) {
            // catch any exceptions thrown during the process and print the errors to screen
            foreach ($ex->getErrors() as $error) {
                $ret['error'][] = $error;
            }
        }
    }
    
    public function getData(){
        return $this->data;
    }
    
    private function getDataFromDatabase() {
        global $db;
        try {
            $query = $db->query("SELECT * FROM `{$this->table}` WHERE meta_key='{$this->meta_key}'");
            $query->setFetchMode(PDO::FETCH_ASSOC);
            $getaweber = $query->fetch();
            $this->data = unserialize($getaweber['meta_value']);

        } catch (Exception $ex) {
            $this->data = array();
        }
    }
    
    public function putData($data){
        $this->data = $data;
    }
    
    public function updateData() {
        global $db;
        $data = serialize($this->data);
        $query = "UPDATE `{$this->table}` set `meta_value`='$data' WHERE `meta_key`='{$this->table}'";
        $db->query($query);
    }
    
    public function authorize() {
        $oauth = new CtctOAuth2($this->data['api_key'], $this->data['consumer_secret'], $this->data['redirect_uri']);
        $ret = '';
        if(isset($_GET['code'])):
            try {
                $accessToken = $oauth->getAccessToken($_GET['code']);
                $this->data['access_token'] = $accessToken;
                $this->updateData();
                $ret = '';
            } catch (OAuth2Exception $ex) {
                $ret = '<span class="label label-important">OAuth2 Error!</span>';
                $ret .= '<div class="container alert-error"><pre class="failure-pre">';
                $ret .= 'Error: ' . $ex->getMessage();
                $ret .= '</pre></div>';
            }
        else:
            $ret = '<span class="label label-important">OAuth2 Error!</span>';
            $ret .= '<div class="container alert-error"><pre class="failure-pre">';
            $ret .= 'Error: ' . $_GET['error'];
            $ret .= '<br />Description: ' . $_GET['error_description'];
            $ret .= '</pre></div>';
        endif;
        
        return $ret;
    }
    
    public function getAuthUrl() {
        $oauth = new CtctOAuth2($this->data['api_key'], $this->data['consumer_secret'], $this->data['redirect_uri']);
        return $oauth->getAuthorizationUrl();
    }
    
    public function authorized() {
        if($this->data['access_token'] != '') {
            return true;
        }
        else {
            return false;
        }
    }
    
    public function deauthorized() {
        global $db;
        $this->data['access_token'] = '';
        $this->data['list_ids'] = array();
        
        $data = serialize($this->data);
        $query = "UPDATE `{$this->table}` set `meta_value`='$data' WHERE `meta_key`='{$this->table}'";
        $db->query($query);
    }
}

